/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import org.jboss.as.logging.AbstractHandlerElement;
import org.jboss.as.logging.FileHandlerAdd;
import org.jboss.as.logging.LogServices;
import org.jboss.as.logging.SizeRotatingFileHandlerElement;
import org.jboss.as.logging.SizeRotatingFileHandlerService;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.services.path.AbstractPathService;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

public class SizeRotatingFileHandlerAdd
extends FileHandlerAdd {
    private static final long serialVersionUID = 3144252544518106859L;
    private long rotateSize = 0x200000L;
    private int maxBackupIndex = 1;

    public SizeRotatingFileHandlerAdd(String name) {
        super(name);
    }

    public long getRotateSize() {
        return this.rotateSize;
    }

    public void setRotateSize(long rotateSize) {
        this.rotateSize = rotateSize;
    }

    public int getMaxBackupIndex() {
        return this.maxBackupIndex;
    }

    public void setMaxBackupIndex(int maxBackupIndex) {
        this.maxBackupIndex = maxBackupIndex;
    }

    @Override
    protected AbstractHandlerElement<?> createElement(String name) {
        SizeRotatingFileHandlerElement element = new SizeRotatingFileHandlerElement(name);
        element.setMaxBackupIndex(this.maxBackupIndex);
        element.setRotateSize(this.rotateSize);
        element.setPath(this.getRelativeTo(), this.getPath());
        return element;
    }

    @Override
    protected <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> handler, P param) {
        try {
            BatchBuilder batchBuilder = updateContext.getBatchBuilder();
            SizeRotatingFileHandlerService service = new SizeRotatingFileHandlerService();
            BatchServiceBuilder serviceBuilder = batchBuilder.addService(LogServices.handlerName(this.getName()), (Service)service);
            String relativeTo = this.getRelativeTo();
            if (relativeTo != null) {
                serviceBuilder.addDependency(AbstractPathService.pathNameOf((String)relativeTo), String.class, service.getRelativeToInjector());
            }
            service.setLevel(Level.parse(this.getLevelName()));
            Boolean autoFlush = this.getAutoflush();
            if (autoFlush != null) {
                service.setAutoflush(autoFlush);
            }
            try {
                service.setEncoding(this.getEncoding());
            }
            catch (UnsupportedEncodingException e) {
                handler.handleFailure((Throwable)e, param);
                return;
            }
            try {
                service.setPath(this.getPath());
            }
            catch (FileNotFoundException e) {
                handler.handleFailure((Throwable)e, param);
                return;
            }
            service.setFormatterSpec(this.getFormatter());
            service.setMaxBackupIndex(this.maxBackupIndex);
            service.setRotateSize(this.rotateSize);
            serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
            serviceBuilder.addListener((ServiceListener)new UpdateResultHandler.ServiceStartListener(handler, param));
        }
        catch (Throwable t) {
            handler.handleFailure(t, param);
        }
    }
}

