/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.logging.AbstractLoggingSubsystemUpdate;
import org.jboss.as.logging.LogServices;
import org.jboss.as.logging.LoggingSubsystemElement;
import org.jboss.as.logging.RootLoggerAdd;
import org.jboss.as.logging.RootLoggerElement;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceNotFoundException;

public class RootLoggerRemove
extends AbstractLoggingSubsystemUpdate<Void> {
    private static final long serialVersionUID = -9178350859833986971L;

    protected <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        ServiceController service;
        try {
            service = updateContext.getServiceContainer().getRequiredService(LogServices.ROOT_LOGGER);
        }
        catch (ServiceNotFoundException e) {
            resultHandler.handleFailure((Throwable)e, param);
            return;
        }
        service.setMode(ServiceController.Mode.REMOVE);
        service.addListener((ServiceListener)new UpdateResultHandler.ServiceRemoveListener(resultHandler, param));
    }

    public RootLoggerAdd getCompensatingUpdate(LoggingSubsystemElement original) {
        RootLoggerElement loggerElement = original.getRootLogger();
        if (loggerElement == null) {
            return null;
        }
        RootLoggerAdd add = new RootLoggerAdd();
        add.setLevelName(loggerElement.getLevel());
        return add;
    }

    protected void applyUpdate(LoggingSubsystemElement element) throws UpdateFailedException {
        RootLoggerElement logger = element.clearRootLogger();
        if (logger == null) {
            throw new UpdateFailedException("Root logger not defined");
        }
    }
}

