/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.ExtensionContext;
import org.jboss.as.logging.AbstractFormatterSpec;
import org.jboss.as.logging.AbstractLoggingSubsystemUpdate;
import org.jboss.as.logging.AsyncHandlerAdd;
import org.jboss.as.logging.Attribute;
import org.jboss.as.logging.ConsoleHandlerAdd;
import org.jboss.as.logging.Element;
import org.jboss.as.logging.FileHandlerAdd;
import org.jboss.as.logging.LoggerAdd;
import org.jboss.as.logging.LoggerHandlerAdd;
import org.jboss.as.logging.LoggingSubsystemAdd;
import org.jboss.as.logging.LoggingSubsystemElement;
import org.jboss.as.logging.Namespace;
import org.jboss.as.logging.OverflowAction;
import org.jboss.as.logging.PatternFormatterSpec;
import org.jboss.as.logging.PeriodicRotatingFileHandlerAdd;
import org.jboss.as.logging.RootLoggerAdd;
import org.jboss.as.logging.SizeRotatingFileHandlerAdd;
import org.jboss.as.logging.Target;
import org.jboss.as.model.AbstractSubsystemAdd;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.ParseResult;
import org.jboss.as.model.ParseUtils;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public final class LoggingSubsystemParser
implements XMLElementReader<ParseResult<ExtensionContext.SubsystemConfiguration<LoggingSubsystemElement>>>,
XMLStreamConstants {
    private static final LoggingSubsystemParser INSTANCE = new LoggingSubsystemParser();
    private static final Pattern SIZE_PATTERN = Pattern.compile("(\\d+)([kKmMgGbBtT])?");

    public static LoggingSubsystemParser getInstance() {
        return INSTANCE;
    }

    private static XMLStreamException unexpectedAttribute(XMLExtendedStreamReader reader, int index) {
        return new XMLStreamException("Unexpected attribute '" + reader.getAttributeName(index) + "' encountered", reader.getLocation());
    }

    private static XMLStreamException duplicateNamedElement(XMLExtendedStreamReader reader, String name) {
        return new XMLStreamException("An element of this type named '" + name + "' has already been declared", reader.getLocation());
    }

    private static XMLStreamException unexpectedElement(XMLExtendedStreamReader reader) {
        return new XMLStreamException("Unexpected element '" + reader.getName() + "' encountered", reader.getLocation());
    }

    private static XMLStreamException missingRequired(XMLExtendedStreamReader reader, Set<?> required) {
        StringBuilder b = new StringBuilder();
        Iterator<?> iterator = required.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            b.append(o.toString());
            if (!iterator.hasNext()) continue;
            b.append(", ");
        }
        return new XMLStreamException("Missing required attribute(s): " + b, reader.getLocation());
    }

    public void readElement(XMLExtendedStreamReader reader, ParseResult<ExtensionContext.SubsystemConfiguration<LoggingSubsystemElement>> result) throws XMLStreamException {
        ArrayList updates = new ArrayList();
        this.readElement(reader, updates);
        result.setResult((Object)new ExtensionContext.SubsystemConfiguration((AbstractSubsystemAdd)new LoggingSubsystemAdd(), updates));
    }

    void readElement(XMLExtendedStreamReader reader, List<? super AbstractSubsystemUpdate<LoggingSubsystemElement, ?>> updates) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw LoggingSubsystemParser.unexpectedAttribute(reader, 0);
        }
        HashSet<String> loggerNames = new HashSet<String>();
        HashSet<String> handlerNames = new HashSet<String>();
        boolean gotRoot = false;
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case LOGGING_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case LOGGER: {
                            LoggingSubsystemParser.parseLoggerElement(reader, updates, loggerNames);
                            continue block12;
                        }
                        case ROOT_LOGGER: {
                            if (gotRoot) {
                                throw LoggingSubsystemParser.unexpectedElement(reader);
                            }
                            gotRoot = true;
                            LoggingSubsystemParser.parseRootLoggerElement(reader, updates);
                            continue block12;
                        }
                        case CONSOLE_HANDLER: {
                            LoggingSubsystemParser.parseConsoleHandlerElement(reader, updates, handlerNames);
                            continue block12;
                        }
                        case FILE_HANDLER: {
                            LoggingSubsystemParser.parseFileHandlerElement(reader, updates, handlerNames);
                            continue block12;
                        }
                        case PERIODIC_ROTATING_FILE_HANDLER: {
                            LoggingSubsystemParser.parsePeriodicRotatingFileHandlerElement(reader, updates, handlerNames);
                            continue block12;
                        }
                        case SIZE_ROTATING_FILE_HANDLER: {
                            LoggingSubsystemParser.parseSizeRotatingHandlerElement(reader, updates, handlerNames);
                            continue block12;
                        }
                        case ASYNC_HANDLER: {
                            LoggingSubsystemParser.parseAsyncHandlerElement(reader, updates, handlerNames);
                            continue block12;
                        }
                    }
                    reader.handleAny(updates);
                    continue block12;
                }
            }
            throw LoggingSubsystemParser.unexpectedElement(reader);
        }
    }

    private static void parseLoggerElement(XMLExtendedStreamReader reader, List<? super AbstractLoggingSubsystemUpdate<?>> list, Set<String> names) throws XMLStreamException {
        String name = null;
        boolean useParentHandlers = true;
        EnumSet<Attribute> required = EnumSet.of(Attribute.CATEGORY);
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw LoggingSubsystemParser.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CATEGORY: {
                    name = value;
                    break;
                }
                case USE_PARENT_HANDLERS: {
                    useParentHandlers = Boolean.parseBoolean(value);
                    break;
                }
                default: {
                    throw LoggingSubsystemParser.unexpectedAttribute(reader, i);
                }
            }
            required.remove((Object)attribute);
        }
        if (!required.isEmpty()) {
            throw LoggingSubsystemParser.missingRequired(reader, required);
        }
        assert (name != null);
        if (names.contains(name)) {
            throw LoggingSubsystemParser.duplicateNamedElement(reader, name);
        }
        LoggerAdd add = new LoggerAdd(name);
        add.setUseParentHandlers(useParentHandlers);
        List<String> handlers = null;
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case LOGGING_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    if (encountered.contains((Object)element)) {
                        throw LoggingSubsystemParser.duplicateNamedElement(reader, reader.getLocalName());
                    }
                    encountered.add(element);
                    switch (element) {
                        case LEVEL: {
                            add.setLevelName(LoggingSubsystemParser.parseLevelElement(reader));
                            continue block12;
                        }
                        case HANDLERS: {
                            handlers = LoggingSubsystemParser.parseHandlersElement(reader);
                            continue block12;
                        }
                    }
                    throw LoggingSubsystemParser.unexpectedElement(reader);
                }
            }
            throw LoggingSubsystemParser.unexpectedElement(reader);
        }
        list.add(add);
        if (handlers != null) {
            for (String handlerName : handlers) {
                list.add(new LoggerHandlerAdd(name, handlerName));
            }
        }
    }

    private static String parseLevelElement(XMLExtendedStreamReader reader) throws XMLStreamException {
        String level = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw LoggingSubsystemParser.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    level = value;
                    break;
                }
                default: {
                    throw LoggingSubsystemParser.unexpectedAttribute(reader, i);
                }
            }
            required.remove((Object)attribute);
        }
        if (!required.isEmpty()) {
            throw LoggingSubsystemParser.missingRequired(reader, required);
        }
        if (reader.nextTag() != 2) {
            throw LoggingSubsystemParser.unexpectedElement(reader);
        }
        return level;
    }

    private static void parseRootLoggerElement(XMLExtendedStreamReader reader, List<? super AbstractLoggingSubsystemUpdate<?>> list) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw LoggingSubsystemParser.unexpectedAttribute(reader, 0);
        }
        String level = null;
        List<String> handlers = null;
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case LOGGING_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    if (encountered.contains((Object)element)) {
                        throw LoggingSubsystemParser.duplicateNamedElement(reader, reader.getLocalName());
                    }
                    encountered.add(element);
                    switch (element) {
                        case LEVEL: {
                            level = LoggingSubsystemParser.parseLevelElement(reader);
                            continue block7;
                        }
                        case HANDLERS: {
                            handlers = LoggingSubsystemParser.parseHandlersElement(reader);
                            continue block7;
                        }
                    }
                    throw LoggingSubsystemParser.unexpectedElement(reader);
                }
            }
            throw LoggingSubsystemParser.unexpectedElement(reader);
        }
        RootLoggerAdd add = new RootLoggerAdd();
        add.setLevelName(level);
        list.add(add);
        if (handlers != null) {
            for (String handlerName : handlers) {
                list.add(new LoggerHandlerAdd("", handlerName));
            }
        }
    }

    private static AbstractFormatterSpec parseFormatterElement(XMLExtendedStreamReader reader) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw LoggingSubsystemParser.unexpectedAttribute(reader, 0);
        }
        PatternFormatterSpec formatterSpec = null;
        if (reader.nextTag() != 1) {
            throw new XMLStreamException("Missing required nested filter element", reader.getLocation());
        }
        block0 : switch (Namespace.forUri(reader.getNamespaceURI())) {
            case LOGGING_1_0: {
                Element element = Element.forName(reader.getLocalName());
                switch (element) {
                    case PATTERN_FORMATTER: {
                        formatterSpec = LoggingSubsystemParser.parsePatternFormatterElement(reader);
                        break block0;
                    }
                }
                throw LoggingSubsystemParser.unexpectedElement(reader);
            }
            default: {
                throw LoggingSubsystemParser.unexpectedElement(reader);
            }
        }
        if (reader.nextTag() != 2) {
            throw LoggingSubsystemParser.unexpectedElement(reader);
        }
        return formatterSpec;
    }

    private static PatternFormatterSpec parsePatternFormatterElement(XMLExtendedStreamReader reader) throws XMLStreamException {
        String pattern = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATTERN);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw LoggingSubsystemParser.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case PATTERN: {
                    pattern = value;
                    continue block3;
                }
                default: {
                    throw LoggingSubsystemParser.unexpectedAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw LoggingSubsystemParser.missingRequired(reader, required);
        }
        if (reader.nextTag() != 2) {
            throw LoggingSubsystemParser.unexpectedElement(reader);
        }
        PatternFormatterSpec spec = new PatternFormatterSpec(pattern);
        return spec;
    }

    private static void parseConsoleHandlerElement(XMLExtendedStreamReader reader, List<? super AbstractLoggingSubsystemUpdate<?>> list, Set<String> names) throws XMLStreamException {
        String name = null;
        boolean autoflush = true;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw LoggingSubsystemParser.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block10;
                }
                case AUTOFLUSH: {
                    autoflush = Boolean.parseBoolean(value);
                    continue block10;
                }
                default: {
                    throw LoggingSubsystemParser.unexpectedAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw LoggingSubsystemParser.missingRequired(reader, required);
        }
        String levelName = null;
        String encoding = null;
        AbstractFormatterSpec formatterSpec = null;
        String target = null;
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block11: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw LoggingSubsystemParser.unexpectedElement(reader);
            }
            switch (element) {
                case LEVEL: {
                    levelName = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name");
                    continue block11;
                }
                case ENCODING: {
                    encoding = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value");
                    continue block11;
                }
                case FORMATTER: {
                    formatterSpec = LoggingSubsystemParser.parseFormatterElement(reader);
                    continue block11;
                }
                case TARGET: {
                    target = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name");
                    if (target.equals("System.out") || target.equals("System.err")) continue block11;
                    throw new XMLStreamException("Invalid value for target name", reader.getLocation());
                }
            }
            throw LoggingSubsystemParser.unexpectedElement(reader);
        }
        if (names.contains(name)) {
            throw LoggingSubsystemParser.duplicateNamedElement(reader, name);
        }
        ConsoleHandlerAdd add = new ConsoleHandlerAdd(name);
        add.setAutoflush(autoflush);
        add.setLevelName(levelName);
        add.setEncoding(encoding);
        add.setFormatter(formatterSpec);
        if (target != null) {
            add.setTarget(Target.fromString(target));
        }
        list.add(add);
    }

    private static void parseFileHandlerElement(XMLExtendedStreamReader reader, List<? super AbstractLoggingSubsystemUpdate<?>> list, Set<String> names) throws XMLStreamException {
        String name = null;
        boolean autoflush = true;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw LoggingSubsystemParser.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block11;
                }
                case AUTOFLUSH: {
                    autoflush = Boolean.parseBoolean(value);
                    continue block11;
                }
                default: {
                    throw LoggingSubsystemParser.unexpectedAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw LoggingSubsystemParser.missingRequired(reader, required);
        }
        String levelName = null;
        String encoding = null;
        FileSpec fileSpec = null;
        boolean append = true;
        AbstractFormatterSpec formatterSpec = null;
        EnumSet<Element> requiredElem = EnumSet.of(Element.FILE);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block12: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw LoggingSubsystemParser.unexpectedElement(reader);
            }
            requiredElem.remove((Object)element);
            switch (element) {
                case LEVEL: {
                    levelName = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name");
                    continue block12;
                }
                case ENCODING: {
                    encoding = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value");
                    continue block12;
                }
                case FORMATTER: {
                    formatterSpec = LoggingSubsystemParser.parseFormatterElement(reader);
                    continue block12;
                }
                case FILE: {
                    fileSpec = LoggingSubsystemParser.parseFileElement(reader);
                    continue block12;
                }
                case APPEND: {
                    append = Boolean.parseBoolean(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                    continue block12;
                }
            }
            throw LoggingSubsystemParser.unexpectedElement(reader);
        }
        if (!requiredElem.isEmpty()) {
            throw LoggingSubsystemParser.missingRequired(reader, required);
        }
        if (names.contains(name)) {
            throw LoggingSubsystemParser.duplicateNamedElement(reader, name);
        }
        FileHandlerAdd add = new FileHandlerAdd(name);
        add.setAutoflush(autoflush);
        add.setLevelName(levelName);
        add.setEncoding(encoding);
        add.setFormatter(formatterSpec);
        add.setPath(fileSpec.fileName);
        add.setRelativeTo(fileSpec.relativeTo);
        add.setAppend(append);
        list.add(add);
    }

    private static FileSpec parseFileElement(XMLExtendedStreamReader reader) throws XMLStreamException {
        String path = null;
        String relativeTo = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATH);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw LoggingSubsystemParser.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case PATH: {
                    path = value;
                    continue block4;
                }
                case RELATIVE_TO: {
                    relativeTo = value;
                    continue block4;
                }
                default: {
                    throw LoggingSubsystemParser.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return new FileSpec(relativeTo, path);
    }

    private static void parsePeriodicRotatingFileHandlerElement(XMLExtendedStreamReader reader, List<? super AbstractLoggingSubsystemUpdate<?>> list, Set<String> names) throws XMLStreamException {
        String name = null;
        boolean autoflush = true;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw LoggingSubsystemParser.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block12;
                }
                case AUTOFLUSH: {
                    autoflush = Boolean.parseBoolean(value);
                    continue block12;
                }
                default: {
                    throw LoggingSubsystemParser.unexpectedAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw LoggingSubsystemParser.missingRequired(reader, required);
        }
        String levelName = null;
        String encoding = null;
        String suffix = null;
        FileSpec fileSpec = null;
        boolean append = true;
        AbstractFormatterSpec formatterSpec = null;
        EnumSet<Element> requiredElem = EnumSet.of(Element.FILE, Element.SUFFIX);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block13: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw LoggingSubsystemParser.unexpectedElement(reader);
            }
            requiredElem.remove((Object)element);
            switch (element) {
                case LEVEL: {
                    levelName = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name");
                    continue block13;
                }
                case ENCODING: {
                    encoding = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value");
                    continue block13;
                }
                case FORMATTER: {
                    formatterSpec = LoggingSubsystemParser.parseFormatterElement(reader);
                    continue block13;
                }
                case FILE: {
                    fileSpec = LoggingSubsystemParser.parseFileElement(reader);
                    continue block13;
                }
                case APPEND: {
                    append = Boolean.parseBoolean(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                    continue block13;
                }
                case SUFFIX: {
                    suffix = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value");
                    continue block13;
                }
            }
            throw LoggingSubsystemParser.unexpectedElement(reader);
        }
        if (!requiredElem.isEmpty()) {
            throw LoggingSubsystemParser.missingRequired(reader, required);
        }
        if (names.contains(name)) {
            throw LoggingSubsystemParser.duplicateNamedElement(reader, name);
        }
        PeriodicRotatingFileHandlerAdd add = new PeriodicRotatingFileHandlerAdd(name);
        add.setAutoflush(autoflush);
        add.setLevelName(levelName);
        add.setEncoding(encoding);
        add.setFormatter(formatterSpec);
        add.setPath(fileSpec.fileName);
        add.setRelativeTo(fileSpec.relativeTo);
        add.setAppend(append);
        add.setSuffix(suffix);
        list.add(add);
    }

    private static void parseSizeRotatingHandlerElement(XMLExtendedStreamReader reader, List<? super AbstractLoggingSubsystemUpdate<?>> list, Set<String> names) throws XMLStreamException {
        String name = null;
        boolean autoflush = true;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block15: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw LoggingSubsystemParser.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block15;
                }
                case AUTOFLUSH: {
                    autoflush = Boolean.parseBoolean(value);
                    continue block15;
                }
                default: {
                    throw LoggingSubsystemParser.unexpectedAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw LoggingSubsystemParser.missingRequired(reader, required);
        }
        String levelName = null;
        String encoding = null;
        FileSpec fileSpec = null;
        boolean append = true;
        long rotateSize = 0L;
        int maxBackupIndex = 1;
        AbstractFormatterSpec formatterSpec = null;
        EnumSet<Element> requiredElem = EnumSet.of(Element.FILE);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block16: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw LoggingSubsystemParser.unexpectedElement(reader);
            }
            requiredElem.remove((Object)element);
            switch (element) {
                case LEVEL: {
                    levelName = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name");
                    continue block16;
                }
                case ENCODING: {
                    encoding = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value");
                    continue block16;
                }
                case FORMATTER: {
                    formatterSpec = LoggingSubsystemParser.parseFormatterElement(reader);
                    continue block16;
                }
                case FILE: {
                    fileSpec = LoggingSubsystemParser.parseFileElement(reader);
                    continue block16;
                }
                case APPEND: {
                    append = Boolean.parseBoolean(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                    continue block16;
                }
                case ROTATE_SIZE: {
                    rotateSize = LoggingSubsystemParser.parseSize(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                    continue block16;
                }
                case MAX_BACKUP_INDEX: {
                    try {
                        maxBackupIndex = Integer.parseInt(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                        continue block16;
                    }
                    catch (NumberFormatException e) {
                        throw new XMLStreamException(e.getMessage(), reader.getLocation(), e);
                    }
                }
            }
            throw LoggingSubsystemParser.unexpectedElement(reader);
        }
        if (!requiredElem.isEmpty()) {
            throw LoggingSubsystemParser.missingRequired(reader, required);
        }
        if (names.contains(name)) {
            throw LoggingSubsystemParser.duplicateNamedElement(reader, name);
        }
        SizeRotatingFileHandlerAdd add = new SizeRotatingFileHandlerAdd(name);
        add.setAutoflush(autoflush);
        add.setLevelName(levelName);
        add.setEncoding(encoding);
        add.setFormatter(formatterSpec);
        add.setPath(fileSpec.fileName);
        add.setRelativeTo(fileSpec.relativeTo);
        add.setAppend(append);
        if (rotateSize > 0L) {
            add.setRotateSize(rotateSize);
        }
        if (maxBackupIndex > 0) {
            add.setMaxBackupIndex(maxBackupIndex);
        }
        list.add(add);
    }

    private static long parseSize(String value) {
        Matcher matcher = SIZE_PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw new IllegalArgumentException();
        }
        long qty = Long.parseLong(matcher.group(1), 10);
        String chr = matcher.group(2);
        if (chr != null) {
            switch (chr.charAt(0)) {
                case 'B': 
                case 'b': {
                    break;
                }
                case 'K': 
                case 'k': {
                    qty <<= 10;
                    break;
                }
                case 'M': 
                case 'm': {
                    qty <<= 20;
                    break;
                }
                case 'G': 
                case 'g': {
                    qty <<= 30;
                    break;
                }
                case 'T': 
                case 't': {
                    qty <<= 40;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return qty;
    }

    private static void parseAsyncHandlerElement(XMLExtendedStreamReader reader, List<? super AbstractLoggingSubsystemUpdate<?>> list, Set<String> names) throws XMLStreamException {
        String name = null;
        boolean autoflush = true;
        EnumSet<Attribute> required = EnumSet.of(Attribute.FILE_NAME, Attribute.NAME);
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw LoggingSubsystemParser.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block9;
                }
                default: {
                    throw LoggingSubsystemParser.unexpectedAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw LoggingSubsystemParser.missingRequired(reader, required);
        }
        String levelName = null;
        List<String> subhandlers = null;
        int queueLength = 0;
        OverflowAction overflowAction = OverflowAction.BLOCK;
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block10: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw LoggingSubsystemParser.unexpectedElement(reader);
            }
            switch (element) {
                case LEVEL: {
                    levelName = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name");
                    continue block10;
                }
                case SUBHANDLERS: {
                    subhandlers = LoggingSubsystemParser.parseHandlersElement(reader);
                    continue block10;
                }
                case QUEUE_LENGTH: {
                    queueLength = Integer.parseInt(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                    continue block10;
                }
                case OVERFLOW_ACTION: {
                    overflowAction = OverflowAction.valueOf(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value").toUpperCase(Locale.US));
                    continue block10;
                }
            }
            throw LoggingSubsystemParser.unexpectedElement(reader);
        }
        if (names.contains(name)) {
            throw LoggingSubsystemParser.duplicateNamedElement(reader, name);
        }
        AsyncHandlerAdd add = new AsyncHandlerAdd(name);
        if (subhandlers != null) {
            add.setSubhandlers(subhandlers.toArray(new String[subhandlers.size()]));
        }
        if (queueLength > 0) {
            add.setQueueLength(queueLength);
        }
        add.setOverflowAction(overflowAction);
        add.setAutoflush(autoflush);
        add.setLevelName(levelName);
        list.add(add);
    }

    private static List<String> parseHandlersElement(XMLExtendedStreamReader reader) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw LoggingSubsystemParser.unexpectedAttribute(reader, 0);
        }
        ArrayList<String> handlers = new ArrayList<String>();
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case LOGGING_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case HANDLER: {
                            handlers.add(LoggingSubsystemParser.parseRefElement(reader));
                            continue block6;
                        }
                    }
                    throw LoggingSubsystemParser.unexpectedElement(reader);
                }
            }
            throw LoggingSubsystemParser.unexpectedElement(reader);
        }
        return handlers;
    }

    private static String parseRefElement(XMLExtendedStreamReader reader) throws XMLStreamException {
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw LoggingSubsystemParser.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    break;
                }
                default: {
                    throw LoggingSubsystemParser.unexpectedAttribute(reader, i);
                }
            }
            required.remove((Object)attribute);
        }
        if (!required.isEmpty()) {
            throw LoggingSubsystemParser.missingRequired(reader, required);
        }
        if (reader.nextTag() != 2) {
            throw LoggingSubsystemParser.unexpectedElement(reader);
        }
        return name;
    }

    private static final class FileSpec {
        private final String relativeTo;
        private final String fileName;

        private FileSpec(String relativeTo, String fileName) {
            this.relativeTo = relativeTo;
            this.fileName = fileName;
        }
    }
}

