/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.logging.AbstractLoggingSubsystemUpdate;
import org.jboss.as.logging.LogServices;
import org.jboss.as.logging.LoggerAdd;
import org.jboss.as.logging.LoggerElement;
import org.jboss.as.logging.LoggingSubsystemElement;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

public class LoggerRemove
extends AbstractLoggingSubsystemUpdate<Void> {
    private static final long serialVersionUID = -9178350859833986971L;
    private final String name;

    public LoggerRemove(String name) {
        this.name = name;
    }

    protected <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        try {
            ServiceController controller = updateContext.getServiceContainer().getRequiredService(LogServices.loggerName(this.name));
            controller.setMode(ServiceController.Mode.REMOVE);
            controller.addListener((ServiceListener)new UpdateResultHandler.ServiceRemoveListener(resultHandler, param));
        }
        catch (Throwable t) {
            resultHandler.handleFailure(t, param);
        }
    }

    public LoggerAdd getCompensatingUpdate(LoggingSubsystemElement original) {
        LoggerElement loggerElement = original.getLogger(this.name);
        LoggerAdd add = new LoggerAdd(this.name, loggerElement.isUseParentHandlers());
        add.setLevelName(loggerElement.getLevel());
        return add;
    }

    protected void applyUpdate(LoggingSubsystemElement element) throws UpdateFailedException {
        LoggerElement logger = element.removeLogger(this.name);
        if (logger == null) {
            throw new UpdateFailedException(String.format("logger (%s) does not exist", this.name));
        }
    }
}

