/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.logging.Handler;
import org.jboss.as.logging.AbstractLoggerElement;
import org.jboss.as.logging.AbstractLoggingSubsystemUpdate;
import org.jboss.as.logging.LogServices;
import org.jboss.as.logging.LoggerHandlerRemove;
import org.jboss.as.logging.LoggerHandlerService;
import org.jboss.as.logging.LoggingSubsystemElement;
import org.jboss.as.logging.RootLoggerElement;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceListener;

public final class LoggerHandlerAdd
extends AbstractLoggingSubsystemUpdate<Void> {
    private static final long serialVersionUID = -7863090205710498113L;
    private final String loggerName;
    private final String handlerName;

    public LoggerHandlerAdd(String loggerName, String handlerName) {
        this.loggerName = loggerName;
        this.handlerName = handlerName;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    protected <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> handler, P param) {
        try {
            LoggerHandlerService service = new LoggerHandlerService(this.loggerName);
            BatchServiceBuilder serviceBuilder = updateContext.getBatchBuilder().addService(LogServices.loggerHandlerName(this.loggerName, this.handlerName), (Service)service);
            serviceBuilder.addDependency(LogServices.loggerName(this.loggerName));
            Injector<Handler> injector = service.getHandlerInjector();
            serviceBuilder.addDependency(LogServices.handlerName(this.handlerName), Handler.class, injector);
            serviceBuilder.addListener((ServiceListener)new UpdateResultHandler.ServiceStartListener(handler, param));
        }
        catch (Throwable t) {
            handler.handleFailure(t, param);
            return;
        }
    }

    public AbstractLoggingSubsystemUpdate<Void> getCompensatingUpdate(LoggingSubsystemElement original) {
        return new LoggerHandlerRemove(this.loggerName, this.handlerName);
    }

    protected void applyUpdate(LoggingSubsystemElement element) throws UpdateFailedException {
        RootLoggerElement logger;
        AbstractLoggerElement abstractLoggerElement = logger = this.loggerName.length() == 0 ? element.getRootLogger() : element.getLogger(this.loggerName);
        if (logger == null) {
            throw new UpdateFailedException("No logger element with a name of '" + this.loggerName + "' exists");
        }
        logger.getHandlers().add(this.handlerName);
    }
}

