/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.logging.AbstractHandlerAdd;
import org.jboss.as.logging.AbstractHandlerElement;
import org.jboss.as.logging.AbstractLoggingSubsystemUpdate;
import org.jboss.as.logging.LogServices;
import org.jboss.as.logging.LoggingSubsystemElement;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

public class HandlerRemove
extends AbstractLoggingSubsystemUpdate<Void> {
    private static final long serialVersionUID = 4158226899360272190L;
    private final String name;

    public HandlerRemove(String name) {
        this.name = name;
    }

    protected <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        try {
            ServiceController controller = updateContext.getServiceContainer().getRequiredService(LogServices.handlerName(this.name));
            controller.setMode(ServiceController.Mode.REMOVE);
            controller.addListener((ServiceListener)new UpdateResultHandler.ServiceRemoveListener(resultHandler, param));
        }
        catch (Throwable t) {
            resultHandler.handleFailure(t, param);
            return;
        }
    }

    public AbstractHandlerAdd getCompensatingUpdate(LoggingSubsystemElement original) {
        return original.getHandler(this.name).getAdd();
    }

    protected void applyUpdate(LoggingSubsystemElement element) throws UpdateFailedException {
        AbstractHandlerElement<?> handler = element.removeHandler(this.name);
        if (handler == null) {
            throw new UpdateFailedException("failed to remove handler " + this.name);
        }
    }
}

