/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jsr77.managedobject;

import java.util.Collections;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.jboss.as.jsr77.managedobject.BaseHandler;
import org.jboss.as.jsr77.managedobject.J2EEServerHandler;
import org.jboss.as.jsr77.managedobject.ModelReader;
import org.jboss.as.jsr77.managedobject.ObjectNameBuilder;

class J2EEDomainHandler
extends BaseHandler {
    static final J2EEDomainHandler INSTANCE = new J2EEDomainHandler();
    private static final String ATTR_SERVERS = "servers";
    static final String J2EE_TYPE = "J2EEDomain";
    private final String objectName;

    private J2EEDomainHandler() {
        ObjectNameBuilder builder = ObjectNameBuilder.createPlain(J2EE_TYPE, "jboss.jsr77");
        this.objectName = builder.toString();
    }

    @Override
    Set<ObjectName> queryObjectNames(ModelReader reader, ObjectName name, QueryExp query) {
        return Collections.singleton(ObjectNameBuilder.createObjectName(this.objectName));
    }

    @Override
    protected Object getAttribute(ModelReader reader, ObjectName name, String attribute) throws AttributeNotFoundException {
        if (attribute.equals(ATTR_SERVERS)) {
            return new String[]{J2EEServerHandler.INSTANCE.getObjectName()};
        }
        return super.getAttribute(reader, name, attribute);
    }

    @Override
    Set<MBeanAttributeInfo> getAttributeInfos() {
        Set<MBeanAttributeInfo> attributes = super.getAttributeInfos();
        attributes.add(this.createRoMBeanAttributeInfo(ATTR_SERVERS, String.class.getName(), "The servers"));
        return attributes;
    }
}

