/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jsf.subsystem;

import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.jsf.JSFLogger;
import org.jboss.as.jsf.subsystem.JSFResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class JSFExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "jsf";
    public static final String NAMESPACE = "urn:jboss:domain:jsf:1.0";
    private static final JSFSubsystemParser PARSER = new JSFSubsystemParser();
    static final PathElement PATH_SUBSYSTEM = PathElement.pathElement((String)"subsystem", (String)"jsf");
    private static final String RESOURCE_NAME = JSFExtension.class.getPackage().getName() + ".LocalDescriptions";
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 0;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;
    private static final ResourceDefinition JSF_SUBSYSTEM_RESOURCE = new JSFResourceDefinition();

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, JSFExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        JSFLogger.ROOT_LOGGER.debug("Activating JSF(Mojarra) Extension");
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 0, 0);
        subsystem.registerSubsystemModel(JSF_SUBSYSTEM_RESOURCE);
        subsystem.registerXMLElementWriter((XMLElementWriter)PARSER);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, NAMESPACE, (XMLElementReader)PARSER);
    }

    static class JSFSubsystemParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        JSFSubsystemParser() {
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ModelNode addJSFSub = Util.createAddOperation((PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{PATH_SUBSYSTEM}));
            for (int i = 0; i < reader.getAttributeCount(); ++i) {
                if (!reader.getAttributeLocalName(i).equals("default-jsf-impl-slot")) continue;
                JSFResourceDefinition.DEFAULT_JSF_IMPL_SLOT.parseAndSetParameter(reader.getAttributeValue(i), addJSFSub, (XMLStreamReader)reader);
            }
            list.add(addJSFSub);
            reader.nextTag();
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            context.startSubsystemElement(JSFExtension.NAMESPACE, false);
            JSFResourceDefinition.DEFAULT_JSF_IMPL_SLOT.marshallAsAttribute(context.getModelNode(), (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
    }
}

