/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jsf.deployment;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.faces.bean.ManagedBean;
import javax.faces.component.FacesComponent;
import javax.faces.component.behavior.FacesBehavior;
import javax.faces.convert.FacesConverter;
import javax.faces.event.NamedEvent;
import javax.faces.render.FacesBehaviorRenderer;
import javax.faces.render.FacesRenderer;
import javax.faces.validator.FacesValidator;
import org.jboss.as.jsf.JSFMessages;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.web.deployment.ServletContextAttribute;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;

public class JSFAnnotationProcessor
implements DeploymentUnitProcessor {
    public static final String FACES_ANNOTATIONS_SC_ATTR = "org.jboss.as.jsf.FACES_ANNOTATIONS";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        HashMap instances = new HashMap();
        CompositeIndex compositeIndex = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (compositeIndex == null) {
            return;
        }
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        if (module == null) {
            return;
        }
        ModuleClassLoader classLoader = module.getClassLoader();
        for (FacesAnnotation annotation : FacesAnnotation.values()) {
            List annotationInstances = compositeIndex.getAnnotations(annotation.indexName);
            if (annotationInstances == null || annotationInstances.isEmpty()) continue;
            HashSet discoveredClasses = new HashSet();
            instances.put(annotation.annotationClass, discoveredClasses);
            for (AnnotationInstance annotationInstance : annotationInstances) {
                AnnotationTarget target = annotationInstance.target();
                if (target instanceof ClassInfo) {
                    Class<?> annotatedClass;
                    DotName className = ((ClassInfo)ClassInfo.class.cast(target)).name();
                    try {
                        annotatedClass = classLoader.loadClass(className.toString());
                    }
                    catch (ClassNotFoundException e) {
                        throw new DeploymentUnitProcessingException(JSFMessages.MESSAGES.classLoadingFailed(className));
                    }
                    discoveredClasses.add(annotatedClass);
                    continue;
                }
                throw new DeploymentUnitProcessingException(JSFMessages.MESSAGES.invalidAnnotationLocation((Object)annotation, target));
            }
        }
        deploymentUnit.addToAttachmentList(ServletContextAttribute.ATTACHMENT_KEY, (Object)new ServletContextAttribute(FACES_ANNOTATIONS_SC_ATTR, instances));
    }

    public void undeploy(DeploymentUnit context) {
    }

    private static enum FacesAnnotation {
        FACES_COMPONENT(FacesComponent.class),
        FACES_CONVERTER(FacesConverter.class),
        FACES_VALIDATOR(FacesValidator.class),
        FACES_RENDERER(FacesRenderer.class),
        MANAGED_BEAN(ManagedBean.class),
        NAMED_EVENT(NamedEvent.class),
        FACES_BEHAVIOR(FacesBehavior.class),
        FACES_BEHAVIOR_RENDERER(FacesBehaviorRenderer.class);

        private final Class<? extends Annotation> annotationClass;
        private final DotName indexName;

        private FacesAnnotation(Class<? extends Annotation> annotationClass) {
            this.annotationClass = annotationClass;
            this.indexName = DotName.createSimple((String)annotationClass.getName());
        }
    }
}

