/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate4.management;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.jpa.hibernate4.management.HibernateDescriptions;
import org.jboss.as.jpa.hibernate4.management.QueryMetricsHandler;
import org.jboss.as.jpa.spi.PersistenceUnitServiceRegistry;
import org.jboss.dmr.ModelType;

public class QueryResourceDefinition
extends SimpleResourceDefinition {
    public static final SimpleAttributeDefinition QUERY_NAME = new SimpleAttributeDefinitionBuilder("query-name", ModelType.STRING).build();
    public static final SimpleAttributeDefinition EXECUTE_COUNT = new SimpleAttributeDefinitionBuilder("query-execution-count", ModelType.LONG).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME}).build();
    public static final SimpleAttributeDefinition HIT_COUNT = new SimpleAttributeDefinitionBuilder("query-cache-hit-count", ModelType.LONG).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME}).build();
    public static final SimpleAttributeDefinition PUT_COUNT = new SimpleAttributeDefinitionBuilder("query-cache-put-count", ModelType.LONG).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME}).build();
    public static final SimpleAttributeDefinition MISS_COUNT = new SimpleAttributeDefinitionBuilder("query-cache-miss-count", ModelType.LONG).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME}).build();
    public static final SimpleAttributeDefinition EXEC_ROW_COUNT = new SimpleAttributeDefinitionBuilder("query-execution-row-count", ModelType.LONG).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME}).build();
    public static final SimpleAttributeDefinition AVG_TIME = new SimpleAttributeDefinitionBuilder("query-execution-average-time", ModelType.LONG).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME}).build();
    public static final SimpleAttributeDefinition MAX_TIME = new SimpleAttributeDefinitionBuilder("query-execution-max-time", ModelType.LONG).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME}).build();
    public static final SimpleAttributeDefinition MIN_TIME = new SimpleAttributeDefinitionBuilder("query-execution-min-time", ModelType.LONG).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME}).build();
    private final PersistenceUnitServiceRegistry persistenceUnitRegistry;

    QueryResourceDefinition(PersistenceUnitServiceRegistry persistenceUnitRegistry) {
        super(PathElement.pathElement((String)"query-cache"), HibernateDescriptions.getResourceDescriptionResolver("hibernate.statistics.query"));
        this.persistenceUnitRegistry = persistenceUnitRegistry;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerMetric((AttributeDefinition)QUERY_NAME, QueryMetricsHandler.getOriginalName(this.persistenceUnitRegistry));
        resourceRegistration.registerMetric((AttributeDefinition)EXECUTE_COUNT, (OperationStepHandler)QueryMetricsHandler.getExecutionCount(this.persistenceUnitRegistry));
        resourceRegistration.registerMetric((AttributeDefinition)HIT_COUNT, (OperationStepHandler)QueryMetricsHandler.getCacheHitCount(this.persistenceUnitRegistry));
        resourceRegistration.registerMetric((AttributeDefinition)PUT_COUNT, (OperationStepHandler)QueryMetricsHandler.getCachePutCount(this.persistenceUnitRegistry));
        resourceRegistration.registerMetric((AttributeDefinition)MISS_COUNT, (OperationStepHandler)QueryMetricsHandler.getCacheMissCount(this.persistenceUnitRegistry));
        resourceRegistration.registerMetric((AttributeDefinition)EXEC_ROW_COUNT, (OperationStepHandler)QueryMetricsHandler.getExecutionRowCount(this.persistenceUnitRegistry));
        resourceRegistration.registerMetric((AttributeDefinition)AVG_TIME, (OperationStepHandler)QueryMetricsHandler.getExecutionAvgTime(this.persistenceUnitRegistry));
        resourceRegistration.registerMetric((AttributeDefinition)MAX_TIME, (OperationStepHandler)QueryMetricsHandler.getExecutionMaxTime(this.persistenceUnitRegistry));
        resourceRegistration.registerMetric((AttributeDefinition)MIN_TIME, (OperationStepHandler)QueryMetricsHandler.getExecutionMinTime(this.persistenceUnitRegistry));
    }
}

