/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.jmx.InvokeMBeanRaw;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class GetMBeanInfoRaw
extends AbstractRuntimeOnlyHandler {
    private static final String MBEAN_NAME = "mbean-name";

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        MBeanInfo result;
        ServiceController service = context.getServiceRegistry(false).getRequiredService(MBeanServerService.SERVICE_NAME);
        MBeanServer server = (MBeanServer)service.getValue();
        String name = operation.require(MBEAN_NAME).asString();
        try {
            ObjectName beanName = ObjectName.getInstance(name);
            result = server.getMBeanInfo(beanName);
        }
        catch (Exception e) {
            throw new OperationFailedException(e.getMessage(), (Throwable)e, new ModelNode().set(e.getMessage()));
        }
        context.getResult().set(InvokeMBeanRaw.getBytes(result));
        context.completeStep();
    }
}

