/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnectorServer;
import javax.management.remote.rmi.RMIJRMPServerImpl;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.as.network.SocketBinding;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class JMXConnectorService
implements Service<Void> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"mbean", "connector"});
    private static final String SERVER_HOSTNAME = "java.rmi.server.hostname";
    private static final String RMI_BIND_NAME = "jmxrmi";
    private static final int BACKLOG = 50;
    private final Logger log = Logger.getLogger(JMXConnectorService.class);
    private final InjectedValue<MBeanServer> injectedMBeanServer = new InjectedValue();
    private final InjectedValue<SocketBinding> registryPortBinding = new InjectedValue();
    private final InjectedValue<SocketBinding> serverPortBinding = new InjectedValue();
    private RMIConnectorServer adapter;
    private RMIJRMPServerImpl rmiServer;
    private Registry registry;

    public static ServiceController<?> addService(ServiceTarget target, String serverBinding, String registryBinding, ServiceListener<Object> ... listeners) {
        JMXConnectorService jmxConnectorService = new JMXConnectorService();
        return target.addService(SERVICE_NAME, (Service)jmxConnectorService).addDependency(MBeanServerService.SERVICE_NAME, MBeanServer.class, jmxConnectorService.getMBeanServerServiceInjector()).addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{registryBinding}), SocketBinding.class, jmxConnectorService.getRegistryPortBinding()).addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{serverBinding}), SocketBinding.class, jmxConnectorService.getServerPortBinding()).addListener(listeners).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    public void start(StartContext context) throws StartException {
        this.log.info((Object)"Starting remote JMX connector");
        this.setRmiServerProperty(((SocketBinding)this.serverPortBinding.getValue()).getAddress().getHostAddress());
        try {
            SocketBinding registryBinding = (SocketBinding)this.registryPortBinding.getValue();
            JMXServerSocketFactory registrySocketFactory = new JMXServerSocketFactory(registryBinding);
            SocketBinding rmiServerBinding = (SocketBinding)this.serverPortBinding.getValue();
            JMXServerSocketFactory serverSocketFactory = new JMXServerSocketFactory(rmiServerBinding);
            this.registry = LocateRegistry.createRegistry(this.getRmiRegistryPort(), null, registrySocketFactory);
            HashMap env = new HashMap();
            this.rmiServer = new RMIJRMPServerImpl(this.getRmiServerPort(), null, serverSocketFactory, env);
            JMXServiceURL url = this.buildJMXServiceURL();
            this.adapter = new RMIConnectorServer(url, env, this.rmiServer, (MBeanServer)this.injectedMBeanServer.getValue());
            this.adapter.start();
            this.registry.rebind(RMI_BIND_NAME, this.rmiServer.toStub());
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop(StopContext context) {
        try {
            this.registry.unbind(RMI_BIND_NAME);
        }
        catch (Exception e) {
            this.log.error((Object)"Could not unbind jmx connector from registry", (Throwable)e);
        }
        finally {
            try {
                this.adapter.stop();
            }
            catch (Exception e) {
                this.log.error((Object)"Could not stop connector server", (Throwable)e);
            }
            finally {
                try {
                    UnicastRemoteObject.unexportObject(this.registry, true);
                }
                catch (Exception e) {
                    this.log.error((Object)"Could not shutdown rmi registry");
                }
            }
        }
        this.log.info((Object)"JMX remote connector stopped");
    }

    private JMXServiceURL buildJMXServiceURL() throws MalformedURLException {
        String host = this.getRmiRegistryAddressString();
        if (host.indexOf(58) != -1) {
            host = "[" + host + "]";
        }
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi://" + host);
        return url;
    }

    public Void getValue() throws IllegalStateException {
        return null;
    }

    public InjectedValue<MBeanServer> getMBeanServerServiceInjector() {
        return this.injectedMBeanServer;
    }

    public InjectedValue<SocketBinding> getRegistryPortBinding() {
        return this.registryPortBinding;
    }

    public InjectedValue<SocketBinding> getServerPortBinding() {
        return this.serverPortBinding;
    }

    private int getRmiRegistryPort() {
        return ((SocketBinding)this.registryPortBinding.getValue()).getSocketAddress().getPort();
    }

    private int getRmiServerPort() {
        return ((SocketBinding)this.serverPortBinding.getValue()).getSocketAddress().getPort();
    }

    private InetAddress getRmiRegistryAddress() {
        return ((SocketBinding)this.registryPortBinding.getValue()).getSocketAddress().getAddress();
    }

    private String getRmiRegistryAddressString() {
        return ((SocketBinding)this.registryPortBinding.getValue()).getSocketAddress().getAddress().getHostAddress();
    }

    private void setRmiServerProperty(final String address) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    System.setProperty(JMXConnectorService.SERVER_HOSTNAME, address);
                    return null;
                }
            });
        } else {
            System.setProperty(SERVER_HOSTNAME, address);
        }
    }

    private static class JMXServerSocketFactory
    implements RMIServerSocketFactory,
    Serializable {
        private static final long serialVersionUID = 1564081885379700777L;
        private final SocketBinding socketBinding;

        public JMXServerSocketFactory(SocketBinding socketBinding) {
            this.socketBinding = socketBinding;
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            int fixed = this.socketBinding.isFixedPort() ? 0 : 1;
            int configuredPort = this.socketBinding.getPort() + this.socketBinding.getSocketBindings().getPortOffset() * fixed;
            if (port != configuredPort) {
                throw new IllegalStateException(String.format("Received request for server socket %s on port [%d] but am configured for port [%d]", this.socketBinding.getName(), port, configuredPort));
            }
            return this.socketBinding.createServerSocket(50);
        }
    }
}

