/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.jmx.JMXConnectorService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

class JMXConnectorAdd
extends AbstractAddStepHandler {
    static final JMXConnectorAdd INSTANCE = new JMXConnectorAdd();
    static final String OPERATION_NAME = "add-connector";

    private JMXConnectorAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
        String serverBinding = operation.require("server-binding").asString();
        String registryBinding = operation.require("registry-binding").asString();
        model.get("server-binding").set(serverBinding);
        model.get("registry-binding").set(registryBinding);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        String serverBinding = operation.require("server-binding").asString();
        String registryBinding = operation.require("registry-binding").asString();
        ServiceTarget target = context.getServiceTarget();
        newControllers.add(JMXConnectorService.addService(target, serverBinding, registryBinding, new ServiceListener[]{verificationHandler}));
    }
}

