/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jdr;

import java.net.URL;
import java.net.URLDecoder;
import java.util.Date;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.jdr.CompressionType;
import org.jboss.as.jdr.JdrLogger;
import org.jboss.as.jdr.JdrMessages;
import org.jboss.as.jdr.JdrReport;
import org.jboss.as.jdr.SoSReport;
import org.jboss.dmr.ModelNode;
import org.python.util.PythonInterpreter;

public class SosInterpreter {
    private String jbossHomeDir = null;
    private String reportLocationDir = System.getProperty("user.dir");
    private ModelControllerClient controllerClient = null;

    public SosInterpreter() {
        this.jbossHomeDir = System.getProperty("jboss.home.dir");
        if (this.jbossHomeDir == null) {
            this.jbossHomeDir = System.getenv("JBOSS_HOME");
        }
        JdrLogger.ROOT_LOGGER.debug("JBoss Home directory: " + this.jbossHomeDir);
    }

    public JdrReport collect() throws OperationFailedException {
        return this.collect(null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JdrReport collect(String username, String password, String host, String port) throws OperationFailedException {
        JdrLogger.ROOT_LOGGER.startingCollection();
        Date startTime = new Date();
        String homeDir = this.getJbossHomeDir();
        if (homeDir == null) {
            JdrLogger.ROOT_LOGGER.jbossHomeNotSet();
            throw new OperationFailedException(JdrMessages.MESSAGES.jbossHomeNotSet(), new ModelNode().set(JdrMessages.MESSAGES.jbossHomeNotSet()));
        }
        String pyLocation = this.getPythonScriptLocation();
        JdrLogger.ROOT_LOGGER.debug("Location of JDR scripts: " + pyLocation);
        String locationDir = this.getReportLocationDir();
        JdrLogger.ROOT_LOGGER.debug("locationDir = " + locationDir);
        JdrLogger.ROOT_LOGGER.debug("homeDir = " + SosInterpreter.cleanPath(homeDir));
        String pathToReport = "";
        PythonInterpreter interpreter = new PythonInterpreter();
        try {
            SoSReport reporter = new SoSReport(interpreter, pyLocation);
            reporter.setUsername(username);
            reporter.setPassword(password);
            reporter.setHostname(host);
            reporter.setPort(port);
            reporter.setHome(homeDir);
            reporter.setTmpDir(locationDir);
            reporter.setCompressionType(CompressionType.ZIP);
            pathToReport = reporter.execute();
        }
        catch (Throwable t) {
            JdrLogger.ROOT_LOGGER.pythonExceptionEncountered(t);
        }
        finally {
            interpreter.cleanup();
        }
        Date endTime = new Date();
        JdrLogger.ROOT_LOGGER.endingCollection();
        JdrReport result = new JdrReport();
        result.setStartTime(startTime);
        result.setEndTime(endTime);
        result.setLocation(pathToReport);
        return result;
    }

    public void setReportLocationDir(String dir) {
        this.reportLocationDir = dir;
    }

    public String getReportLocationDir() {
        return SosInterpreter.cleanPath(this.reportLocationDir);
    }

    public void setControllerClient(ModelControllerClient controllerClient) {
        this.controllerClient = controllerClient;
    }

    public String getJbossHomeDir() {
        if (this.jbossHomeDir == null) {
            this.jbossHomeDir = System.getenv("JBOSS_HOME");
        }
        return SosInterpreter.cleanPath(this.jbossHomeDir);
    }

    public void setJbossHomeDir(String jbossHomeDir) throws IllegalArgumentException {
        if (jbossHomeDir == null) {
            throw JdrMessages.MESSAGES.varNull("jbossHomeDir");
        }
        this.jbossHomeDir = jbossHomeDir;
    }

    public static String getPath(String path) {
        return path.split(":", 2)[1].split("!")[0];
    }

    public static String cleanPath(String path) {
        try {
            path = URLDecoder.decode(path, "utf-8");
        }
        catch (Exception e) {
            JdrLogger.ROOT_LOGGER.debug(e);
        }
        return path.replace("\\", "\\\\");
    }

    private String getPythonScriptLocation() {
        URL pyURL = this.getClass().getClassLoader().getResource("sos");
        String decodedPath = SosInterpreter.cleanPath(pyURL.getPath());
        return SosInterpreter.getPath(decodedPath);
    }
}

