/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jdr;

import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.jdr.CompressionType;
import org.jboss.as.jdr.ModelControllerClientProxy;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.adapter.ClassicPyObjectAdapter;
import org.python.util.PythonInterpreter;

public class SoSReport {
    PyObject sosreport;
    private static final String SET_OPTION = "set_option";
    private static final String SET_GLOBAL = "set_global_plugin_option";

    public SoSReport(PythonInterpreter interpreter, String pyLocation) {
        interpreter.exec("import sys");
        interpreter.exec("sys.path.append(\"" + pyLocation + "\")");
        interpreter.exec("from sos.sosreport import SoSReport");
        interpreter.exec("reporter = SoSReport([])");
        this.sosreport = interpreter.get("reporter");
        this.enableOption("--batch");
        this.enableOption("--report");
        this.enableOption("--silent");
    }

    public String execute() {
        return this.sosreport.invoke("execute").asString();
    }

    public void setOption(String name, String value) {
        this.sosreport.invoke(SET_OPTION, (PyObject)new PyString(name), (PyObject)new PyString(value));
    }

    public void enableOption(String name) {
        this.sosreport.invoke(SET_OPTION, (PyObject)new PyString(name));
    }

    public void setGlobal(String name, Object value) {
        if (value != null) {
            ClassicPyObjectAdapter adapter = new ClassicPyObjectAdapter();
            this.sosreport.invoke(SET_GLOBAL, (PyObject)new PyString(name), adapter.adapt(value));
        }
    }

    public void setCompressionType(CompressionType type) {
        this.setOption("--compression-type", type.toString());
    }

    public void setClientController(ModelControllerClient controllerClient) {
        if (controllerClient != null) {
            this.setGlobal("controller_client_proxy", new ModelControllerClientProxy(controllerClient));
        }
    }

    public void setTmpDir(String tmpDir) {
        this.setOption("--tmp-dir", tmpDir);
    }

    public void setUsername(String username) {
        this.setGlobal("as7_user", username);
    }

    public void setPassword(String password) {
        this.setGlobal("as7_pass", password);
    }

    public void setHostname(String hostname) {
        this.setGlobal("as7_host", hostname);
    }

    public void setPort(String port) {
        this.setGlobal("as7_port", port);
    }

    public void setPort(int port) {
        this.setGlobal("as7_port", Integer.valueOf(port).toString());
    }

    public void setHome(String homeDir) {
        this.setGlobal("as7_home", homeDir);
    }
}

