/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jdr;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.jdr.JdrReport;
import org.jboss.as.jdr.JdrReportCollector;
import org.jboss.as.jdr.JdrReportDescriptions;
import org.jboss.as.jdr.JdrReportService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceRegistry;

public class JdrReportRequestHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "generate-jdr-report";
    public static final JdrReportRequestHandler INSTANCE = new JdrReportRequestHandler();
    private final ParametersValidator validator = new ParametersValidator();

    private JdrReportRequestHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.validator.validate(operation);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServiceRegistry registry = context.getServiceRegistry(false);
                JdrReportCollector jdrCollector = (JdrReportCollector)JdrReportCollector.class.cast(registry.getRequiredService(JdrReportService.SERVICE_NAME).getValue());
                ModelNode response = context.getResult();
                JdrReport report = jdrCollector.collect();
                if (report.getStartTime() != null) {
                    response.get("start-time").set(report.getStartTime().toString());
                }
                if (report.getEndTime() != null) {
                    response.get("end-time").set(report.getEndTime().toString());
                }
                response.get("report-location").set(report.getLocation());
                context.completeStep();
            }
        }, OperationContext.Stage.RUNTIME);
        context.completeStep();
    }

    public ModelNode getModelDescription(Locale locale) {
        return JdrReportDescriptions.getJdrRequestDescription(locale);
    }
}

