/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxr.extension;

import java.util.List;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.jaxr.JAXRConfiguration;
import org.jboss.as.jaxr.extension.JAXRDependencyProcessor;
import org.jboss.as.jaxr.extension.JAXRWriteAttributeHandler;
import org.jboss.as.jaxr.service.JAXRConfigurationService;
import org.jboss.as.jaxr.service.JAXRConnectionFactoryService;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

class JAXRSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    private final JAXRConfiguration config;

    JAXRSubsystemAdd(JAXRConfiguration config) {
        this.config = config;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (String attr : JAXRConfiguration.OPTIONAL_ATTRIBUTES) {
            ModelNode node = operation.get(attr);
            if (!node.isDefined()) continue;
            JAXRWriteAttributeHandler.applyUpdateToConfig(this.config, attr, node);
            model.get(attr).set(node);
        }
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, final ServiceVerificationHandler verifyHandler, final List<ServiceController<?>> newControllers) throws OperationFailedException {
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("jaxr", Phase.DEPENDENCIES, 5632, (DeploymentUnitProcessor)new JAXRDependencyProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServiceTarget serviceTarget = context.getServiceTarget();
                newControllers.add(JAXRConfigurationService.addService(serviceTarget, JAXRSubsystemAdd.this.config, new ServiceListener[]{verifyHandler}));
                newControllers.add(JAXRConnectionFactoryService.addService(serviceTarget, new ServiceListener[]{verifyHandler}));
                context.completeStep();
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

