/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxr.extension;

import java.util.Locale;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.jaxr.JAXRConfiguration;
import org.jboss.as.jaxr.extension.JAXRPropertyWrite;
import org.jboss.dmr.ModelNode;

public class JAXRPropertyRemove
extends AbstractRemoveStepHandler {
    private final JAXRConfiguration config;
    static DescriptionProvider DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ModelNode node = new ModelNode();
            node.get("operation-name").set("remove");
            node.get("description").set(JAXRConfiguration.getResourceBundle(locale).getString("jaxr.property.remove"));
            node.get("request-properties").setEmptyObject();
            return node;
        }
    };

    JAXRPropertyRemove(JAXRConfiguration config) {
        this.config = config;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String propertyName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        this.config.applyUpdateToConfig(propertyName, null);
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String propertyName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        this.config.applyUpdateToConfig(propertyName, JAXRPropertyWrite.VALUE.resolveModelAttribute(context, model).asString());
    }
}

