/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller;

import java.util.Map;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.TransformerRegistry;

class DomainTransformers {
    private static final ModelVersion IGNORED_SUBSYSTEMS = ModelVersion.create((int)-1);
    private static final ResourceTransformer IGNORED_EXTENSIONS = new IgnoreExtensionResourceTransformer();

    DomainTransformers() {
    }

    public static void initializeDomainRegistry(TransformerRegistry registry) {
    }

    static class IgnoreExtensionResourceTransformer
    implements ResourceTransformer {
        IgnoreExtensionResourceTransformer() {
        }

        public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
            PathElement element = address.getLastElement();
            TransformationTarget target = context.getTarget();
            ExtensionRegistry registry = target.getExtensionRegistry();
            Map subsystems = registry.getAvailableSubsystems(element.getValue());
            if (subsystems != null) {
                for (Map.Entry subsystem : subsystems.entrySet()) {
                    String name = (String)subsystem.getKey();
                    target.addSubsystemVersion(name, IGNORED_SUBSYSTEMS);
                }
            }
        }
    }
}

