/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.DomainModelUtil;
import org.jboss.as.host.controller.HostControllerConfigurationPersister;
import org.jboss.as.host.controller.descriptions.HostRootDescription;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.dmr.ModelNode;

public class LocalDomainControllerAddHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "write-local-domain-controller";
    private final ManagementResourceRegistration rootRegistration;
    private final HostControllerConfigurationPersister overallConfigPersister;
    private final HostFileRepository fileRepository;
    private final LocalHostControllerInfoImpl hostControllerInfo;
    private final ContentRepository contentRepository;
    private final DomainController domainController;
    private final ExtensionRegistry extensionRegistry;
    private final PathManagerService pathManager;

    public static LocalDomainControllerAddHandler getInstance(ManagementResourceRegistration rootRegistration, LocalHostControllerInfoImpl hostControllerInfo, HostControllerConfigurationPersister overallConfigPersister, HostFileRepository fileRepository, ContentRepository contentRepository, DomainController domainController, ExtensionRegistry extensionRegistry, PathManagerService pathManager) {
        return new LocalDomainControllerAddHandler(rootRegistration, hostControllerInfo, overallConfigPersister, fileRepository, contentRepository, domainController, extensionRegistry, pathManager);
    }

    protected LocalDomainControllerAddHandler(ManagementResourceRegistration rootRegistration, LocalHostControllerInfoImpl hostControllerInfo, HostControllerConfigurationPersister overallConfigPersister, HostFileRepository fileRepository, ContentRepository contentRepository, DomainController domainController, ExtensionRegistry extensionRegistry, PathManagerService pathManager) {
        this.rootRegistration = rootRegistration;
        this.overallConfigPersister = overallConfigPersister;
        this.fileRepository = fileRepository;
        this.hostControllerInfo = hostControllerInfo;
        this.contentRepository = contentRepository;
        this.domainController = domainController;
        this.extensionRegistry = extensionRegistry;
        this.pathManager = pathManager;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        ModelNode dc = model.get("domain-controller");
        dc.get("local").setEmptyObject();
        if (dc.has("remote")) {
            dc.remove("remote");
        }
        this.initializeDomain();
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    protected void initializeDomain() {
        this.hostControllerInfo.setMasterDomainController(true);
        this.overallConfigPersister.initializeDomainConfigurationPersister(false);
        DomainModelUtil.initializeMasterDomainRegistry(this.rootRegistration, this.overallConfigPersister.getDomainPersister(), this.contentRepository, this.fileRepository, this.domainController, this.extensionRegistry, this.pathManager);
    }

    public ModelNode getModelDescription(Locale locale) {
        return HostRootDescription.getLocalDomainControllerAdd(locale);
    }
}

