/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.interfaces.InetAddressUtil;
import org.jboss.as.host.controller.HostControllerBootstrap;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostControllerMessages;
import org.jboss.as.host.controller.SecurityActions;
import org.jboss.as.host.controller.SystemExiter;
import org.jboss.as.process.protocol.StreamUtils;
import org.jboss.as.version.ProductConfig;
import org.jboss.logging.MDC;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.handlers.ConsoleHandler;
import org.jboss.modules.Module;
import org.jboss.stdio.LoggingOutputStream;
import org.jboss.stdio.NullInputStream;
import org.jboss.stdio.SimpleStdioContextSelector;
import org.jboss.stdio.StdioContext;
import org.jboss.stdio.StdioContextSelector;

public final class Main {
    public static void main(String[] args) throws IOException {
        MDC.put((String)"process", (Object)"host controller");
        InputStream in = System.in;
        PrintStream out = System.out;
        PrintStream err = System.err;
        byte[] authKey = new byte[16];
        try {
            StreamUtils.readFully((InputStream)System.in, (byte[])authKey);
        }
        catch (IOException e) {
            System.err.println(HostControllerMessages.MESSAGES.failedToReadAuthenticationKey(e));
            System.exit(1);
            return;
        }
        try {
            Class.forName(ConsoleHandler.class.getName(), true, ConsoleHandler.class.getClassLoader());
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        StdioContext.install();
        StdioContext context = StdioContext.create((InputStream)new NullInputStream(), (OutputStream)new LoggingOutputStream((java.util.logging.Logger)Logger.getLogger((String)"stdout"), (Level)org.jboss.logmanager.Level.INFO), (OutputStream)new LoggingOutputStream((java.util.logging.Logger)Logger.getLogger((String)"stderr"), (Level)org.jboss.logmanager.Level.ERROR));
        StdioContext.setStdioContextSelector((StdioContextSelector)new SimpleStdioContextSelector(context));
        Main.create(args, in, out, err, authKey);
        while (in.read() != -1) {
        }
        System.exit(0);
    }

    private Main() {
    }

    private static HostControllerBootstrap create(String[] args, InputStream stdin, PrintStream stdout, PrintStream stderr, byte[] authCode) {
        Main main = new Main();
        return main.boot(args, stdin, stdout, stderr, authCode);
    }

    /*
     * Loose catch block
     */
    private HostControllerBootstrap boot(String[] args, InputStream stdin, PrintStream stdout, PrintStream stderr, byte[] authCode) {
        HostControllerEnvironment config;
        block5: {
            config = Main.determineEnvironment(args, stdin, stdout, stderr);
            if (config != null) break block5;
            this.abort(null);
            return null;
            {
                catch (Throwable t) {
                    this.abort(t, 99);
                    return null;
                }
            }
        }
        try {
            HostControllerBootstrap hc = new HostControllerBootstrap(config, authCode);
            hc.bootstrap();
            return hc;
        }
        catch (Throwable t) {
            this.abort(t);
            return null;
        }
    }

    private void abort(Throwable t) {
        this.abort(t, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abort(Throwable t, int exitCode) {
        try {
            if (t != null) {
                t.printStackTrace();
            } else {
                exitCode = 99;
            }
        }
        finally {
            SystemExiter.exit(exitCode);
        }
    }

    public static HostControllerEnvironment determineEnvironment(String[] args, InputStream stdin, PrintStream stdout, PrintStream stderr) {
        Integer pmPort = null;
        InetAddress pmAddress = null;
        PCSocketConfig pcSocketConfig = new PCSocketConfig();
        String defaultJVM = null;
        boolean isRestart = false;
        boolean backupDomainFiles = false;
        boolean cachedDc = false;
        String domainConfig = null;
        String hostConfig = null;
        RunningMode initialRunningMode = RunningMode.NORMAL;
        Map<String, String> hostSystemProperties = Main.getHostSystemProperties();
        int argsLength = args.length;
        for (int i = 0; i < argsLength; ++i) {
            String arg = args[i];
            try {
                String value;
                if ("--version".equals(arg) || "-v".equals(arg) || "-version".equals(arg) || "-V".equals(arg)) {
                    ProductConfig productConfig = new ProductConfig(Module.getBootModuleLoader(), SecurityActions.getSystemProperty("jboss.home.dir"));
                    System.out.println(productConfig.getPrettyVersionString());
                    return null;
                }
                if ("--help".equals(arg) || "-h".equals(arg) || "-help".equals(arg)) {
                    org.jboss.as.process.Main.usage();
                    return null;
                }
                if ("--properties".equals(arg) || "-properties".equals(arg) || "-P".equals(arg)) {
                    if (Main.processProperties(arg, args[++i], hostSystemProperties)) continue;
                    return null;
                }
                if (arg.startsWith("--properties")) {
                    String urlSpec = Main.parseValue(arg, "--properties");
                    if (urlSpec != null && Main.processProperties(arg, urlSpec, hostSystemProperties)) continue;
                    return null;
                }
                if (arg.startsWith("-P")) {
                    String urlSpec = Main.parseValue(arg, "-P");
                    if (urlSpec != null && Main.processProperties(arg, urlSpec, hostSystemProperties)) continue;
                    return null;
                }
                if (arg.startsWith("-properties")) {
                    String urlSpec = Main.parseValue(arg, "-properties");
                    if (urlSpec != null && Main.processProperties(arg, urlSpec, hostSystemProperties)) continue;
                    return null;
                }
                if ("--pc-port".equals(arg)) {
                    String port = args[++i];
                    try {
                        pmPort = Integer.valueOf(port);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        System.err.println(HostControllerMessages.MESSAGES.invalidValue("--pc-port", "Integer", port));
                        org.jboss.as.process.Main.usage();
                        return null;
                    }
                }
                if (arg.startsWith("--pc-port")) {
                    String val = Main.parseValue(arg, "--pc-port");
                    if (val == null) {
                        return null;
                    }
                    Integer port = Main.parsePort(val, "--pc-port");
                    if (port == null) {
                        return null;
                    }
                    pmPort = port;
                    continue;
                }
                if ("--pc-address".equals(arg)) {
                    String addr = args[++i];
                    try {
                        pmAddress = InetAddress.getByName(addr);
                        continue;
                    }
                    catch (UnknownHostException e) {
                        System.err.println(HostControllerMessages.MESSAGES.unknownHostValue("--pc-address", addr));
                        org.jboss.as.process.Main.usage();
                        return null;
                    }
                }
                if (arg.startsWith("--pc-address")) {
                    String val = Main.parseValue(arg, "--pc-address");
                    if (val == null) {
                        return null;
                    }
                    InetAddress addr = Main.parseAddress(val, arg);
                    if (addr == null) {
                        return null;
                    }
                    pmAddress = addr;
                    continue;
                }
                if (pcSocketConfig.processPCSocketConfigArgument(arg, args, i)) {
                    if (pcSocketConfig.isParseFailed()) {
                        return null;
                    }
                    i += pcSocketConfig.getArgIncrement();
                    continue;
                }
                if ("--process-restarted".equals(arg)) {
                    isRestart = true;
                    continue;
                }
                if ("--backup".equals(arg) || "-backup".equals(arg)) {
                    backupDomainFiles = true;
                    continue;
                }
                if ("--cached-dc".equals(arg) || "-cached-dc".equals(arg)) {
                    cachedDc = true;
                    continue;
                }
                if ("--default-jvm".equals(arg) || "-default-jvm".equals(arg)) {
                    defaultJVM = args[++i];
                    continue;
                }
                if ("--domain-config".equals(arg) || "-c".equals(arg) || "-domain-config".equals(arg)) {
                    domainConfig = args[++i];
                    continue;
                }
                if (arg.startsWith("--domain-config")) {
                    String val = Main.parseValue(arg, "--domain-config");
                    if (val == null) {
                        return null;
                    }
                    domainConfig = val;
                    continue;
                }
                if (arg.startsWith("-c")) {
                    String val = Main.parseValue(arg, "-c");
                    if (val == null) {
                        return null;
                    }
                    domainConfig = val;
                    continue;
                }
                if (arg.startsWith("-domain-config")) {
                    String val = Main.parseValue(arg, "-domain-config");
                    if (val == null) {
                        return null;
                    }
                    domainConfig = val;
                    continue;
                }
                if ("--host-config".equals(arg) || "-host-config".equals(arg)) {
                    hostConfig = args[++i];
                    continue;
                }
                if (arg.startsWith("--host-config")) {
                    String val = Main.parseValue(arg, "--host-config");
                    if (val == null) {
                        return null;
                    }
                    hostConfig = val;
                    continue;
                }
                if (arg.startsWith("-host-config")) {
                    String val = Main.parseValue(arg, "-host-config");
                    if (val == null) {
                        return null;
                    }
                    hostConfig = val;
                    continue;
                }
                if (arg.startsWith("--master-address")) {
                    int idx = arg.indexOf(61);
                    if (idx == arg.length() - 1) {
                        System.err.println(HostControllerMessages.MESSAGES.argumentExpected(arg));
                        org.jboss.as.process.Main.usage();
                        return null;
                    }
                    value = idx > -1 ? arg.substring(idx + 1) : args[++i];
                    hostSystemProperties.put("jboss.domain.master.address", value);
                    SecurityActions.setSystemProperty("jboss.domain.master.address", value);
                    continue;
                }
                if (arg.startsWith("--master-port")) {
                    int idx = arg.indexOf(61);
                    if (idx == arg.length() - 1) {
                        System.err.println(HostControllerMessages.MESSAGES.argumentExpected(arg));
                        org.jboss.as.process.Main.usage();
                        return null;
                    }
                    value = idx > -1 ? arg.substring(idx + 1) : args[++i];
                    Integer port = Main.parsePort(value, "--master-port");
                    if (port == null) {
                        return null;
                    }
                    hostSystemProperties.put("jboss.domain.master.port", value);
                    SecurityActions.setSystemProperty("jboss.domain.master.port", value);
                    continue;
                }
                if ("--admin-only".equals(arg)) {
                    initialRunningMode = RunningMode.ADMIN_ONLY;
                    continue;
                }
                if (arg.startsWith("-D")) {
                    String name;
                    int idx = arg.indexOf("=");
                    if (idx == -1) {
                        name = arg.substring(2);
                        value = "true";
                    } else {
                        name = arg.substring(2, idx);
                        value = arg.substring(idx + 1, arg.length());
                    }
                    SecurityActions.setSystemProperty(name, value);
                    hostSystemProperties.put(name, value);
                    continue;
                }
                if (arg.startsWith("-b")) {
                    int idx = arg.indexOf(61);
                    if (idx == arg.length() - 1) {
                        System.err.println(HostControllerMessages.MESSAGES.argumentExpected(arg));
                        org.jboss.as.process.Main.usage();
                        return null;
                    }
                    value = idx > -1 ? arg.substring(idx + 1) : args[++i];
                    String propertyName = null;
                    propertyName = idx < 0 ? (arg.length() == 2 ? "jboss.bind.address" : "jboss.bind.address." + arg.substring(2)) : (idx == 2 ? "jboss.bind.address" : "jboss.bind.address." + arg.substring(2, idx));
                    hostSystemProperties.put(propertyName, value);
                    SecurityActions.setSystemProperty(propertyName, value);
                    continue;
                }
                if (arg.startsWith("-u")) {
                    int idx = arg.indexOf(61);
                    if (idx == arg.length() - 1) {
                        System.err.println(HostControllerMessages.MESSAGES.argumentExpected(arg));
                        org.jboss.as.process.Main.usage();
                        return null;
                    }
                    value = idx > -1 ? arg.substring(idx + 1) : args[++i];
                    hostSystemProperties.put("jboss.default.multicast.address", value);
                    SecurityActions.setSystemProperty("jboss.default.multicast.address", value);
                    continue;
                }
                System.err.println(HostControllerMessages.MESSAGES.invalidOption(arg));
                org.jboss.as.process.Main.usage();
                return null;
            }
            catch (IndexOutOfBoundsException e) {
                System.err.println(HostControllerMessages.MESSAGES.argumentExpected(arg));
                org.jboss.as.process.Main.usage();
                return null;
            }
        }
        ProductConfig productConfig = new ProductConfig(Module.getBootModuleLoader(), SecurityActions.getSystemProperty("jboss.home.dir"));
        return new HostControllerEnvironment(hostSystemProperties, isRestart, pmAddress, pmPort, pcSocketConfig.getBindAddress(), pcSocketConfig.getBindPort(), defaultJVM, domainConfig, hostConfig, initialRunningMode, backupDomainFiles, cachedDc, productConfig);
    }

    private static String parseValue(String arg, String key) {
        String value = null;
        int splitPos = key.length();
        if (arg.length() <= splitPos + 1 || arg.charAt(splitPos) != '=') {
            org.jboss.as.process.Main.usage();
        } else {
            value = arg.substring(splitPos + 1);
        }
        return value;
    }

    private static boolean processProperties(String arg, String urlSpec, Map<String, String> hostSystemProperties) {
        URL url = null;
        try {
            url = Main.makeURL(urlSpec);
            Properties props = new Properties();
            props.load(url.openConnection().getInputStream());
            SecurityActions.getSystemProperties().putAll((Map<?, ?>)props);
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                hostSystemProperties.put((String)entry.getKey(), (String)entry.getValue());
            }
            return true;
        }
        catch (MalformedURLException e) {
            System.err.println(HostControllerMessages.MESSAGES.malformedUrl(arg));
            org.jboss.as.process.Main.usage();
            return false;
        }
        catch (IOException e) {
            System.err.println(HostControllerMessages.MESSAGES.unableToLoadProperties(url));
            org.jboss.as.process.Main.usage();
            return false;
        }
    }

    private static Integer parsePort(String value, String key) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            System.err.println(HostControllerMessages.MESSAGES.invalidValue(key, "Integer", value));
            org.jboss.as.process.Main.usage();
            return null;
        }
    }

    private static InetAddress parseAddress(String value, String key) {
        try {
            return InetAddress.getByName(value);
        }
        catch (UnknownHostException e) {
            System.err.println(HostControllerMessages.MESSAGES.unknownHostValue(key, value));
            org.jboss.as.process.Main.usage();
            return null;
        }
    }

    private static URL makeURL(String urlspec) throws MalformedURLException {
        URL url;
        urlspec = urlspec.trim();
        try {
            url = new URL(urlspec);
            if (url.getProtocol().equals("file")) {
                File file = new File(url.getFile()).getCanonicalFile();
                url = file.toURI().toURL();
            }
        }
        catch (Exception e) {
            try {
                File file = new File(urlspec).getCanonicalFile();
                url = file.toURI().toURL();
            }
            catch (Exception n) {
                throw new MalformedURLException(n.toString());
            }
        }
        return url;
    }

    private static Map<String, String> getHostSystemProperties() {
        HashMap<String, String> hostSystemProperties = new HashMap<String, String>();
        try {
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            for (String arg : runtime.getInputArguments()) {
                String[] split;
                if (arg == null || arg.length() <= 2 || !arg.startsWith("-D") || hostSystemProperties.containsKey((split = (arg = arg.substring(2)).split("="))[0])) continue;
                String val = split.length == 2 ? split[1] : null;
                hostSystemProperties.put(split[0], val);
            }
        }
        catch (Exception e) {
            System.err.println(HostControllerMessages.MESSAGES.cannotAccessJvmInputArgument(e));
        }
        return hostSystemProperties;
    }

    private static class PCSocketConfig {
        private final String defaultBindAddress;
        private InetAddress bindAddress;
        private int bindPort = 0;
        private int argIncrement = 0;
        private boolean parseFailed;
        private final UnknownHostException uhe;

        private PCSocketConfig() {
            boolean preferIPv6 = Boolean.valueOf(SecurityActions.getSystemProperty("java.net.preferIPv6Addresses", "false"));
            this.defaultBindAddress = preferIPv6 ? "::1" : "127.0.0.1";
            UnknownHostException toCache = null;
            try {
                this.bindAddress = InetAddress.getByName(this.defaultBindAddress);
            }
            catch (UnknownHostException e) {
                try {
                    this.bindAddress = InetAddressUtil.getLocalHost();
                }
                catch (UnknownHostException uhe) {
                    toCache = uhe;
                }
            }
            this.uhe = toCache;
        }

        private InetAddress getBindAddress() {
            if (this.bindAddress == null) {
                throw HostControllerMessages.MESSAGES.cannotObtainValidDefaultAddress(this.uhe, this.defaultBindAddress, "--interprocess-hc-address");
            }
            return this.bindAddress;
        }

        private int getBindPort() {
            return this.bindPort;
        }

        private int getArgIncrement() {
            return this.argIncrement;
        }

        private boolean isParseFailed() {
            return this.parseFailed;
        }

        private boolean processPCSocketConfigArgument(String arg, String[] args, int index) {
            boolean isPCSocketArg = true;
            this.argIncrement = 0;
            if ("--interprocess-hc-address".equals(arg) || "-interprocess-hc-address".equals(arg)) {
                this.setBindAddress(arg, args[index + 1]);
                this.argIncrement = 1;
            } else if (arg.startsWith("--interprocess-hc-address")) {
                String addr = Main.parseValue(arg, "--interprocess-hc-address");
                if (addr == null) {
                    this.parseFailed = true;
                } else {
                    this.setBindAddress(arg, addr);
                }
            } else if (arg.startsWith("-interprocess-hc-address")) {
                String addr = Main.parseValue(arg, "-interprocess-hc-address");
                if (addr == null) {
                    this.parseFailed = true;
                } else {
                    this.setBindAddress(arg, addr);
                }
            } else if ("--interprocess-hc-port".equals(arg) || "-interprocess-hc-port".equals(arg)) {
                this.bindPort = Integer.parseInt(args[index + 1]);
                this.argIncrement = 1;
            } else if (arg.startsWith("--interprocess-hc-port")) {
                String port = Main.parseValue(arg, "--interprocess-hc-port");
                if (port == null) {
                    this.parseFailed = true;
                } else {
                    this.bindPort = Integer.parseInt(port);
                }
            } else if (arg.startsWith("-interprocess-hc-port")) {
                String port = Main.parseValue(arg, "-interprocess-hc-port");
                if (port == null) {
                    this.parseFailed = true;
                } else {
                    this.bindPort = Integer.parseInt(port);
                }
            } else {
                isPCSocketArg = false;
            }
            return isPCSocketArg;
        }

        private void setBindAddress(String key, String value) {
            try {
                this.bindAddress = InetAddress.getByName(value);
            }
            catch (UnknownHostException e) {
                this.parseFailed = true;
                System.out.println(HostControllerMessages.MESSAGES.invalidValue(key, "InetAddress", value));
                org.jboss.as.process.Main.usage();
            }
        }
    }
}

