/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.util.EnumSet;
import org.jboss.as.controller.CompositeOperationHandler;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonProviders;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.operations.common.InterfaceCriteriaWriteHandler;
import org.jboss.as.controller.operations.common.JVMHandlers;
import org.jboss.as.controller.operations.common.NamespaceAddHandler;
import org.jboss.as.controller.operations.common.NamespaceRemoveHandler;
import org.jboss.as.controller.operations.common.PathAddHandler;
import org.jboss.as.controller.operations.common.PathRemoveHandler;
import org.jboss.as.controller.operations.common.ProcessStateAttributeHandler;
import org.jboss.as.controller.operations.common.ResolveExpressionHandler;
import org.jboss.as.controller.operations.common.SchemaLocationAddHandler;
import org.jboss.as.controller.operations.common.SchemaLocationRemoveHandler;
import org.jboss.as.controller.operations.common.SnapshotDeleteHandler;
import org.jboss.as.controller.operations.common.SnapshotListHandler;
import org.jboss.as.controller.operations.common.SnapshotTakeHandler;
import org.jboss.as.controller.operations.common.SystemPropertyAddHandler;
import org.jboss.as.controller.operations.common.SystemPropertyRemoveHandler;
import org.jboss.as.controller.operations.common.SystemPropertyValueWriteAttributeHandler;
import org.jboss.as.controller.operations.common.ValidateOperationHandler;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.operations.global.WriteAttributeHandlers;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.operations.DomainServerLifecycleHandlers;
import org.jboss.as.domain.controller.operations.deployment.HostProcessReloadHandler;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionResourceDefinition;
import org.jboss.as.domain.management.security.SecurityRealmResourceDefinition;
import org.jboss.as.host.controller.HostControllerConfigurationPersister;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostControllerService;
import org.jboss.as.host.controller.HostRunningModeControl;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.descriptions.HostDescriptionProviders;
import org.jboss.as.host.controller.descriptions.HostRootDescription;
import org.jboss.as.host.controller.ignored.IgnoredDomainResourceRegistry;
import org.jboss.as.host.controller.operations.HostShutdownHandler;
import org.jboss.as.host.controller.operations.HostSpecifiedInterfaceAddHandler;
import org.jboss.as.host.controller.operations.HostSpecifiedInterfaceRemoveHandler;
import org.jboss.as.host.controller.operations.HostXmlMarshallingHandler;
import org.jboss.as.host.controller.operations.IsMasterHandler;
import org.jboss.as.host.controller.operations.LocalDomainControllerAddHandler;
import org.jboss.as.host.controller.operations.LocalDomainControllerRemoveHandler;
import org.jboss.as.host.controller.operations.LocalHostAddHandler;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.as.host.controller.operations.RemoteDomainControllerAddHandler;
import org.jboss.as.host.controller.operations.RemoteDomainControllerRemoveHandler;
import org.jboss.as.host.controller.operations.ResolveExpressionOnHostHandler;
import org.jboss.as.host.controller.operations.ServerAddHandler;
import org.jboss.as.host.controller.operations.ServerRemoveHandler;
import org.jboss.as.host.controller.operations.ServerRestartHandler;
import org.jboss.as.host.controller.operations.ServerRestartRequiredServerConfigWriteAttributeHandler;
import org.jboss.as.host.controller.operations.ServerStartHandler;
import org.jboss.as.host.controller.operations.ServerStatusHandler;
import org.jboss.as.host.controller.operations.ServerStopHandler;
import org.jboss.as.host.controller.operations.StartServersHandler;
import org.jboss.as.host.controller.resources.HttpManagementResourceDefinition;
import org.jboss.as.host.controller.resources.NativeManagementResourceDefinition;
import org.jboss.as.platform.mbean.PlatformMBeanResourceRegistrar;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.as.server.operations.RunningModeReadHandler;
import org.jboss.as.server.services.net.SpecifiedInterfaceAddHandler;
import org.jboss.as.server.services.net.SpecifiedInterfaceRemoveHandler;
import org.jboss.as.server.services.net.SpecifiedInterfaceResolveHandler;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.as.server.services.security.VaultAddHandler;
import org.jboss.as.server.services.security.VaultRemoveHandler;
import org.jboss.as.server.services.security.VaultWriteAttributeHandler;
import org.jboss.dmr.ModelType;

public class HostModelUtil {
    public static void createHostRegistry(ManagementResourceRegistration root, HostControllerConfigurationPersister configurationPersister, HostControllerEnvironment environment, HostRunningModeControl runningModeControl, HostFileRepository localFileRepository, LocalHostControllerInfoImpl hostControllerInfo, ServerInventory serverInventory, HostFileRepository remoteFileRepository, ContentRepository contentRepository, DomainController domainController, ExtensionRegistry extensionRegistry, AbstractVaultReader vaultReader, IgnoredDomainResourceRegistry ignoredRegistry, ControlledProcessState processState) {
        ManagementResourceRegistration hostRegistration = root.registerSubModel(PathElement.pathElement((String)"host"), HostDescriptionProviders.HOST_ROOT_PROVIDER);
        LocalHostAddHandler handler = new LocalHostAddHandler(environment, ignoredRegistry);
        hostRegistration.registerOperationHandler("add-host", (OperationStepHandler)handler, (DescriptionProvider)handler, false, OperationEntry.EntryType.PRIVATE);
        EnumSet<OperationEntry.Flag> flags = EnumSet.of(OperationEntry.Flag.READ_ONLY);
        root.registerOperationHandler("read-resource", GlobalOperationHandlers.READ_RESOURCE, CommonProviders.READ_RESOURCE_PROVIDER, true, OperationEntry.EntryType.PUBLIC, flags);
        root.registerOperationHandler("read-attribute", GlobalOperationHandlers.READ_ATTRIBUTE, CommonProviders.READ_ATTRIBUTE_PROVIDER, true, OperationEntry.EntryType.PUBLIC, flags);
        root.registerOperationHandler("read-resource-description", GlobalOperationHandlers.READ_RESOURCE_DESCRIPTION, CommonProviders.READ_RESOURCE_DESCRIPTION_PROVIDER, true, OperationEntry.EntryType.PUBLIC, flags);
        root.registerOperationHandler("read-children-names", GlobalOperationHandlers.READ_CHILDREN_NAMES, CommonProviders.READ_CHILDREN_NAMES_PROVIDER, true, OperationEntry.EntryType.PUBLIC, flags);
        root.registerOperationHandler("read-children-types", GlobalOperationHandlers.READ_CHILDREN_TYPES, CommonProviders.READ_CHILDREN_TYPES_PROVIDER, true, OperationEntry.EntryType.PUBLIC, flags);
        root.registerOperationHandler("read-children-resources", GlobalOperationHandlers.READ_CHILDREN_RESOURCES, CommonProviders.READ_CHILDREN_RESOURCES_PROVIDER, true, OperationEntry.EntryType.PUBLIC, flags);
        root.registerOperationHandler("read-operation-names", GlobalOperationHandlers.READ_OPERATION_NAMES, CommonProviders.READ_OPERATION_NAMES_PROVIDER, true, OperationEntry.EntryType.PUBLIC, flags);
        root.registerOperationHandler("read-operation-description", GlobalOperationHandlers.READ_OPERATION_DESCRIPTION, CommonProviders.READ_OPERATION_PROVIDER, true, OperationEntry.EntryType.PUBLIC, flags);
        root.registerOperationHandler("undefine-attribute", GlobalOperationHandlers.UNDEFINE_ATTRIBUTE, CommonProviders.UNDEFINE_ATTRIBUTE_PROVIDER, true);
        root.registerOperationHandler("write-attribute", GlobalOperationHandlers.WRITE_ATTRIBUTE, CommonProviders.WRITE_ATTRIBUTE_PROVIDER, true);
        root.registerOperationHandler(ValidateOperationHandler.OPERATION_NAME, (OperationStepHandler)ValidateOperationHandler.INSTANCE, (DescriptionProvider)ValidateOperationHandler.INSTANCE, false, OperationEntry.EntryType.PUBLIC, EnumSet.of(OperationEntry.Flag.READ_ONLY));
        root.registerOperationHandler("composite", (OperationStepHandler)CompositeOperationHandler.INSTANCE, (DescriptionProvider)CompositeOperationHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        HostXmlMarshallingHandler xmh = new HostXmlMarshallingHandler((ConfigurationPersister)configurationPersister.getHostPersister(), hostControllerInfo);
        hostRegistration.registerOperationHandler("read-config-as-xml", (OperationStepHandler)xmh, (DescriptionProvider)xmh, false, OperationEntry.EntryType.PUBLIC, flags);
        hostRegistration.registerOperationHandler("add-namespace", (OperationStepHandler)NamespaceAddHandler.INSTANCE, (DescriptionProvider)NamespaceAddHandler.INSTANCE, false);
        hostRegistration.registerOperationHandler("remove-namespace", (OperationStepHandler)NamespaceRemoveHandler.INSTANCE, (DescriptionProvider)NamespaceRemoveHandler.INSTANCE, false);
        hostRegistration.registerOperationHandler("add-schema-location", (OperationStepHandler)SchemaLocationAddHandler.INSTANCE, (DescriptionProvider)SchemaLocationAddHandler.INSTANCE, false);
        hostRegistration.registerOperationHandler("remove-schema-location", (OperationStepHandler)SchemaLocationRemoveHandler.INSTANCE, (DescriptionProvider)SchemaLocationRemoveHandler.INSTANCE, false);
        hostRegistration.registerReadWriteAttribute("name", environment.getProcessNameReadHandler(), environment.getProcessNameWriteHandler(), AttributeAccess.Storage.CONFIGURATION);
        hostRegistration.registerReadOnlyAttribute("master", (OperationStepHandler)IsMasterHandler.INSTANCE, AttributeAccess.Storage.RUNTIME);
        hostRegistration.registerReadOnlyAttribute("host-state", (OperationStepHandler)new ProcessStateAttributeHandler(processState), AttributeAccess.Storage.RUNTIME);
        StartServersHandler ssh = new StartServersHandler(environment, serverInventory, runningModeControl);
        hostRegistration.registerOperationHandler("start-servers", (OperationStepHandler)ssh, (DescriptionProvider)ssh, false, OperationEntry.EntryType.PRIVATE);
        HostShutdownHandler hsh = new HostShutdownHandler(domainController);
        hostRegistration.registerOperationHandler("shutdown", (OperationStepHandler)hsh, (DescriptionProvider)hsh);
        hostRegistration.registerOperationHandler("resolve-expression", (OperationStepHandler)ResolveExpressionHandler.INSTANCE, (DescriptionProvider)ResolveExpressionHandler.INSTANCE, EnumSet.of(OperationEntry.Flag.READ_ONLY));
        hostRegistration.registerOperationHandler("resolve-expression-on-domain", (OperationStepHandler)ResolveExpressionOnHostHandler.INSTANCE, (DescriptionProvider)ResolveExpressionOnHostHandler.INSTANCE, EnumSet.of(OperationEntry.Flag.READ_ONLY, OperationEntry.Flag.DOMAIN_PUSH_TO_SERVERS));
        HostProcessReloadHandler reloadHandler = new HostProcessReloadHandler(HostControllerService.HC_SERVICE_NAME, runningModeControl, HostRootDescription.getResourceDescriptionResolver("host"));
        hostRegistration.registerOperationHandler("reload", (OperationStepHandler)reloadHandler, (DescriptionProvider)reloadHandler);
        RunningModeReadHandler.createAndRegister((RunningModeControl)runningModeControl, (ManagementResourceRegistration)hostRegistration);
        DomainServerLifecycleHandlers.initializeServerInventory(serverInventory);
        hostRegistration.registerOperationHandler("resolve-internet-address", (OperationStepHandler)SpecifiedInterfaceResolveHandler.INSTANCE, (DescriptionProvider)SpecifiedInterfaceResolveHandler.INSTANCE);
        ValidateOperationHandler validateOperationHandler = hostControllerInfo.isMasterDomainController() ? ValidateOperationHandler.INSTANCE : ValidateOperationHandler.SLAVE_HC_INSTANCE;
        hostRegistration.registerOperationHandler(ValidateOperationHandler.OPERATION_NAME, (OperationStepHandler)validateOperationHandler, (DescriptionProvider)validateOperationHandler, false, OperationEntry.EntryType.PRIVATE, EnumSet.of(OperationEntry.Flag.READ_ONLY));
        ManagementResourceRegistration sysProps = hostRegistration.registerSubModel(PathElement.pathElement((String)"system-property"), HostDescriptionProviders.SYSTEM_PROPERTIES_PROVIDER);
        sysProps.registerOperationHandler("add", (OperationStepHandler)SystemPropertyAddHandler.INSTANCE_WITH_BOOTTIME, (DescriptionProvider)SystemPropertyAddHandler.INSTANCE_WITH_BOOTTIME, false);
        sysProps.registerOperationHandler("remove", (OperationStepHandler)SystemPropertyRemoveHandler.INSTANCE, (DescriptionProvider)SystemPropertyRemoveHandler.INSTANCE, false);
        sysProps.registerReadWriteAttribute("value", null, (OperationStepHandler)SystemPropertyValueWriteAttributeHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        sysProps.registerReadWriteAttribute("boot-time", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN), AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration vault = hostRegistration.registerSubModel(PathElement.pathElement((String)"core-service", (String)"vault"), CommonProviders.VAULT_PROVIDER);
        VaultAddHandler vah = new VaultAddHandler(vaultReader);
        vault.registerOperationHandler("add", (OperationStepHandler)vah, (DescriptionProvider)vah, false);
        VaultRemoveHandler vrh = new VaultRemoveHandler(vaultReader);
        vault.registerOperationHandler("remove", (OperationStepHandler)vrh, (DescriptionProvider)vrh, false);
        VaultWriteAttributeHandler.INSTANCE.registerAttributes(vault);
        ManagementResourceRegistration management = hostRegistration.registerSubModel(PathElement.pathElement((String)"core-service", (String)"management"), CommonProviders.MANAGEMENT_WITH_INTERFACES_PROVIDER);
        management.registerSubModel((ResourceDefinition)SecurityRealmResourceDefinition.INSTANCE);
        management.registerSubModel((ResourceDefinition)LdapConnectionResourceDefinition.INSTANCE);
        management.registerSubModel((ResourceDefinition)new NativeManagementResourceDefinition(hostControllerInfo));
        management.registerSubModel((ResourceDefinition)new HttpManagementResourceDefinition(hostControllerInfo, environment));
        PlatformMBeanResourceRegistrar.registerPlatformMBeanResources((ManagementResourceRegistration)hostRegistration);
        LocalDomainControllerAddHandler localDcAddHandler = LocalDomainControllerAddHandler.getInstance(root, hostControllerInfo, configurationPersister, localFileRepository, contentRepository, domainController, extensionRegistry);
        hostRegistration.registerOperationHandler("write-local-domain-controller", (OperationStepHandler)localDcAddHandler, (DescriptionProvider)localDcAddHandler, false);
        hostRegistration.registerOperationHandler("remove-local-domain-controller", (OperationStepHandler)LocalDomainControllerRemoveHandler.INSTANCE, (DescriptionProvider)LocalDomainControllerRemoveHandler.INSTANCE, false);
        RemoteDomainControllerAddHandler remoteDcAddHandler = new RemoteDomainControllerAddHandler(root, hostControllerInfo, configurationPersister, contentRepository, remoteFileRepository, extensionRegistry, ignoredRegistry);
        hostRegistration.registerOperationHandler("write-remote-domain-controller", (OperationStepHandler)remoteDcAddHandler, (DescriptionProvider)remoteDcAddHandler, false);
        hostRegistration.registerOperationHandler("remove-remote-domain-controller", (OperationStepHandler)RemoteDomainControllerRemoveHandler.INSTANCE, (DescriptionProvider)RemoteDomainControllerRemoveHandler.INSTANCE, false);
        ignoredRegistry.registerResources(hostRegistration);
        SnapshotDeleteHandler snapshotDelete = new SnapshotDeleteHandler((ConfigurationPersister)configurationPersister.getHostPersister());
        hostRegistration.registerOperationHandler("delete-snapshot", (OperationStepHandler)snapshotDelete, (DescriptionProvider)snapshotDelete, false);
        SnapshotListHandler snapshotList = new SnapshotListHandler((ConfigurationPersister)configurationPersister.getHostPersister());
        hostRegistration.registerOperationHandler("list-snapshots", (OperationStepHandler)snapshotList, (DescriptionProvider)snapshotList, false);
        SnapshotTakeHandler snapshotTake = new SnapshotTakeHandler((ConfigurationPersister)configurationPersister.getHostPersister());
        hostRegistration.registerOperationHandler("take-snapshot", (OperationStepHandler)snapshotTake, (DescriptionProvider)snapshotTake, false);
        ManagementResourceRegistration jvms = hostRegistration.registerSubModel(PathElement.pathElement((String)"jvm"), CommonProviders.JVM_PROVIDER);
        JVMHandlers.register((ManagementResourceRegistration)jvms);
        ManagementResourceRegistration paths = hostRegistration.registerSubModel(PathElement.pathElement((String)"path"), CommonProviders.SPECIFIED_PATH_PROVIDER);
        paths.registerOperationHandler("add", (OperationStepHandler)PathAddHandler.SPECIFIED_INSTANCE, (DescriptionProvider)PathAddHandler.SPECIFIED_INSTANCE, false);
        paths.registerOperationHandler("remove", (OperationStepHandler)PathRemoveHandler.INSTANCE, (DescriptionProvider)PathRemoveHandler.INSTANCE, false);
        ManagementResourceRegistration interfaces = hostRegistration.registerSubModel(PathElement.pathElement((String)"interface"), CommonProviders.SPECIFIED_INTERFACE_PROVIDER);
        HostSpecifiedInterfaceAddHandler hsiah = new HostSpecifiedInterfaceAddHandler();
        interfaces.registerOperationHandler("add", (OperationStepHandler)hsiah, (DescriptionProvider)hsiah, false);
        HostSpecifiedInterfaceRemoveHandler sirh = new HostSpecifiedInterfaceRemoveHandler();
        interfaces.registerOperationHandler("remove", (OperationStepHandler)sirh, (DescriptionProvider)sirh, false);
        InterfaceCriteriaWriteHandler.register((ManagementResourceRegistration)interfaces);
        interfaces.registerOperationHandler("resolve-internet-address", (OperationStepHandler)SpecifiedInterfaceResolveHandler.INSTANCE, (DescriptionProvider)SpecifiedInterfaceResolveHandler.INSTANCE);
        ManagementResourceRegistration servers = hostRegistration.registerSubModel(PathElement.pathElement((String)"server-config"), HostDescriptionProviders.SERVER_PROVIDER);
        servers.registerOperationHandler("add", (OperationStepHandler)ServerAddHandler.INSTANCE, (DescriptionProvider)ServerAddHandler.INSTANCE, false);
        servers.registerOperationHandler("remove", (OperationStepHandler)ServerRemoveHandler.INSTANCE, (DescriptionProvider)ServerRemoveHandler.INSTANCE, false);
        servers.registerReadWriteAttribute("auto-start", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN), AttributeAccess.Storage.CONFIGURATION);
        servers.registerReadWriteAttribute("socket-binding-group", null, (OperationStepHandler)ServerRestartRequiredServerConfigWriteAttributeHandler.SOCKET_BINDING_GROUP_INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        servers.registerReadWriteAttribute("socket-binding-port-offset", null, (OperationStepHandler)ServerRestartRequiredServerConfigWriteAttributeHandler.SOCKET_BINDING_PORT_OFFSET_INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        servers.registerReadWriteAttribute("priority", null, (OperationStepHandler)new WriteAttributeHandlers.IntRangeValidatingHandler(0), AttributeAccess.Storage.CONFIGURATION);
        servers.registerReadWriteAttribute("cpu-affinity", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        servers.registerReadWriteAttribute("group", null, (OperationStepHandler)ServerRestartRequiredServerConfigWriteAttributeHandler.GROUP_INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        servers.registerMetric("status", (OperationStepHandler)new ServerStatusHandler(serverInventory));
        ServerStartHandler startHandler = new ServerStartHandler(serverInventory);
        servers.registerOperationHandler("start", (OperationStepHandler)startHandler, (DescriptionProvider)startHandler, EnumSet.of(OperationEntry.Flag.HOST_CONTROLLER_ONLY));
        ServerRestartHandler restartHandler = new ServerRestartHandler(serverInventory);
        servers.registerOperationHandler("restart", (OperationStepHandler)restartHandler, (DescriptionProvider)restartHandler, EnumSet.of(OperationEntry.Flag.HOST_CONTROLLER_ONLY));
        ServerStopHandler stopHandler = new ServerStopHandler(serverInventory);
        servers.registerOperationHandler("stop", (OperationStepHandler)stopHandler, (DescriptionProvider)stopHandler, EnumSet.of(OperationEntry.Flag.HOST_CONTROLLER_ONLY));
        ManagementResourceRegistration serverPaths = servers.registerSubModel(PathElement.pathElement((String)"path"), CommonProviders.SPECIFIED_INTERFACE_PROVIDER);
        serverPaths.registerOperationHandler("add", (OperationStepHandler)PathAddHandler.SPECIFIED_INSTANCE, (DescriptionProvider)PathAddHandler.SPECIFIED_INSTANCE, false);
        serverPaths.registerOperationHandler("remove", (OperationStepHandler)PathRemoveHandler.INSTANCE, (DescriptionProvider)PathRemoveHandler.INSTANCE, false);
        ManagementResourceRegistration serverInterfaces = servers.registerSubModel(PathElement.pathElement((String)"interface"), CommonProviders.SPECIFIED_INTERFACE_PROVIDER);
        serverInterfaces.registerOperationHandler("add", (OperationStepHandler)SpecifiedInterfaceAddHandler.INSTANCE, (DescriptionProvider)SpecifiedInterfaceAddHandler.INSTANCE, false);
        serverInterfaces.registerOperationHandler("remove", (OperationStepHandler)SpecifiedInterfaceRemoveHandler.INSTANCE, (DescriptionProvider)SpecifiedInterfaceRemoveHandler.INSTANCE, false);
        InterfaceCriteriaWriteHandler.register((ManagementResourceRegistration)serverInterfaces);
        ManagementResourceRegistration serverSysProps = servers.registerSubModel(PathElement.pathElement((String)"system-property"), HostDescriptionProviders.SERVER_SYSTEM_PROPERTIES_PROVIDER);
        serverSysProps.registerOperationHandler("add", (OperationStepHandler)SystemPropertyAddHandler.INSTANCE_WITH_BOOTTIME, (DescriptionProvider)SystemPropertyAddHandler.INSTANCE_WITH_BOOTTIME, false);
        serverSysProps.registerOperationHandler("remove", (OperationStepHandler)SystemPropertyRemoveHandler.INSTANCE, (DescriptionProvider)SystemPropertyRemoveHandler.INSTANCE, false);
        serverSysProps.registerReadWriteAttribute("value", null, (OperationStepHandler)SystemPropertyValueWriteAttributeHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        serverSysProps.registerReadWriteAttribute("boot-time", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN), AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration serverVMs = servers.registerSubModel(PathElement.pathElement((String)"jvm"), JVMHandlers.SERVER_MODEL_PROVIDER);
        JVMHandlers.register((ManagementResourceRegistration)serverVMs, (boolean)true);
    }
}

