/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.mgmt;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.as.host.controller.ManagedServerLifecycleCallback;
import org.jboss.as.host.controller.mgmt.ManagementCommunicationService;
import org.jboss.as.protocol.Connection;
import org.jboss.as.protocol.ProtocolUtils;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.AbstractMessageHandler;
import org.jboss.as.protocol.mgmt.ManagementOperationHandler;
import org.jboss.as.protocol.mgmt.ManagementResponse;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class ServerToHostOperationHandler
extends AbstractMessageHandler
implements ManagementOperationHandler,
Service<ManagementOperationHandler> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.host.controller.mgmt");
    public static final ServiceName SERVICE_NAME = ManagementCommunicationService.SERVICE_NAME.append(new String[]{"server", "to", "host", "controller"});
    private final InjectedValue<ManagedServerLifecycleCallback> callback = new InjectedValue();

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public ManagementOperationHandler getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public byte getIdentifier() {
        return 127;
    }

    public void handle(Connection connection, InputStream inputStream) throws IOException {
        ProtocolUtils.expectHeader((InputStream)inputStream, (int)2);
        byte commandCode = StreamUtils.readByte((InputStream)inputStream);
        AbstractMessageHandler operation = this.operationFor(commandCode);
        if (operation == null) {
            throw new IOException("Invalid command code " + commandCode + " received");
        }
        operation.handle(connection, inputStream);
    }

    private AbstractMessageHandler operationFor(byte commandByte) {
        switch (commandByte) {
            case 0: {
                return new ServerRegisterCommand();
            }
        }
        return null;
    }

    public InjectedValue<ManagedServerLifecycleCallback> getCallback() {
        return this.callback;
    }

    private class ServerRegisterCommand
    extends ManagementResponse {
        private Connection connection;

        private ServerRegisterCommand() {
        }

        protected byte getResponseCode() {
            return 2;
        }

        public void handle(Connection connection, InputStream input) throws IOException {
            this.connection = connection;
            super.handle(connection, input);
        }

        protected void readRequest(InputStream input) throws IOException {
            ProtocolUtils.expectHeader((InputStream)input, (int)1);
            String serverName = StreamUtils.readUTFZBytes((InputStream)input);
            log.infof("Server [%s] registered using connection [%s]", (Object)serverName, (Object)this.connection);
            ((ManagedServerLifecycleCallback)ServerToHostOperationHandler.this.callback.getValue()).serverRegistered(serverName, this.connection);
        }
    }
}

