/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.embedded;

import __redirected.__JAXPRedirected;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import java.util.logging.LogManager;
import org.jboss.as.embedded.InitialModuleLoaderFactory;
import org.jboss.as.embedded.SecurityActions;
import org.jboss.as.embedded.StandaloneServer;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.log.JDKModuleLogger;
import org.jboss.modules.log.ModuleLogger;

public class EmbeddedServerFactory {
    private EmbeddedServerFactory() {
    }

    public static StandaloneServer create(ModuleLoader moduleLoader, File jbossHomeDir, Properties systemProps, Map<String, String> systemEnv) {
        try {
            ModuleIdentifier serverModuleId = ModuleIdentifier.create((String)"org.jboss.as.server");
            Module serverModule = moduleLoader.loadModule(serverModuleId);
            ModuleClassLoader serverModuleClassLoader = serverModule.getClassLoader();
            Class embeddedStandAloneServerFactoryClass = serverModuleClassLoader.loadClass("org.jboss.as.server.EmbeddedStandAloneServerFactory");
            Method createMethod = embeddedStandAloneServerFactoryClass.getMethod("create", File.class, ModuleLoader.class, Properties.class, Map.class);
            StandaloneServer standaloneServer = (StandaloneServer)createMethod.invoke(null, jbossHomeDir, moduleLoader, systemProps, systemEnv);
            return standaloneServer;
        }
        catch (ModuleLoadException e) {
            throw new RuntimeException(e.getMessage() + " in " + moduleLoader, e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StandaloneServer create(File jbossHomeDir, Properties systemProps, Map<String, String> systemEnv, String ... systemPackages) {
        if (jbossHomeDir == null || !jbossHomeDir.isDirectory()) {
            throw new IllegalStateException("Invalid jboss.home.dir: " + jbossHomeDir);
        }
        if (systemProps.getProperty("jboss.home.dir") == null) {
            systemProps.setProperty("jboss.home.dir", jbossHomeDir.getAbsolutePath());
        }
        File modulesDir = new File(jbossHomeDir + "/modules");
        ModuleLoader moduleLoader = InitialModuleLoaderFactory.getModuleLoader(modulesDir, systemPackages);
        try {
            Module.registerURLStreamHandlerFactoryModule((Module)moduleLoader.loadModule(ModuleIdentifier.create((String)"org.jboss.vfs")));
            ModuleIdentifier logModuleId = ModuleIdentifier.create((String)"org.jboss.logmanager");
            ModuleClassLoader logModuleClassLoader = moduleLoader.loadModule(logModuleId).getClassLoader();
            ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader((ClassLoader)logModuleClassLoader);
                systemProps.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
                if (LogManager.getLogManager().getClass() == LogManager.class) {
                    System.err.println("WARNING: Failed to load the specified logmodule " + logModuleId);
                } else {
                    Module.setModuleLogger((ModuleLogger)new JDKModuleLogger());
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(ctxClassLoader);
            }
            __JAXPRedirected.changeAll((ModuleIdentifier)ModuleIdentifier.fromString((String)"javax.xml.jaxp-provider"), (ModuleLoader)moduleLoader);
            return EmbeddedServerFactory.create(moduleLoader, jbossHomeDir, systemProps, systemEnv);
        }
        catch (ModuleLoadException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static void main(String[] args) throws Throwable {
        SecurityActions.setSystemProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
        String jbossHomeKey = "jboss.home";
        String jbossHomeProp = System.getProperty(jbossHomeKey);
        if (jbossHomeProp == null) {
            throw new IllegalStateException("Cannot find system property: " + jbossHomeKey);
        }
        File jbossHomeDir = new File(jbossHomeProp);
        if (!jbossHomeDir.isDirectory()) {
            throw new IllegalStateException("Invalid jboss home directory: " + jbossHomeDir);
        }
        Module.registerURLStreamHandlerFactoryModule((Module)Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"org.jboss.vfs")));
        StandaloneServer server = EmbeddedServerFactory.create(jbossHomeDir, System.getProperties(), System.getenv(), new String[0]);
        server.start();
        server.stop();
        System.exit(0);
    }
}

