/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote.protocol.versionone;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.jboss.as.clustering.registry.Registry;
import org.jboss.as.clustering.registry.RegistryCollector;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.deployment.DeploymentModuleIdentifier;
import org.jboss.as.ejb3.deployment.DeploymentRepository;
import org.jboss.as.ejb3.deployment.DeploymentRepositoryListener;
import org.jboss.as.ejb3.deployment.ModuleDeployment;
import org.jboss.as.ejb3.remote.EJBRemoteTransactionsRepository;
import org.jboss.as.ejb3.remote.protocol.versionone.AbstractMessageHandler;
import org.jboss.as.ejb3.remote.protocol.versionone.ChannelAssociation;
import org.jboss.as.ejb3.remote.protocol.versionone.ClusterTopologyWriter;
import org.jboss.as.ejb3.remote.protocol.versionone.MethodInvocationMessageHandler;
import org.jboss.as.ejb3.remote.protocol.versionone.ModuleAvailabilityWriter;
import org.jboss.as.ejb3.remote.protocol.versionone.SessionOpenRequestHandler;
import org.jboss.as.ejb3.remote.protocol.versionone.TransactionRequestHandler;
import org.jboss.as.network.ClientMapping;
import org.jboss.logging.Logger;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.MessageOutputStream;
import org.xnio.IoUtils;

public class VersionOneProtocolChannelReceiver
implements Channel.Receiver,
DeploymentRepositoryListener,
RegistryCollector.Listener<String, List<ClientMapping>> {
    private static final Logger logger = Logger.getLogger(VersionOneProtocolChannelReceiver.class);
    private static final byte HEADER_SESSION_OPEN_REQUEST = 1;
    private static final byte HEADER_INVOCATION_REQUEST = 3;
    private static final byte HEADER_TX_COMMIT_REQUEST = 15;
    private static final byte HEADER_TX_ROLLBACK_REQUEST = 16;
    private static final byte HEADER_TX_PREPARE_REQUEST = 17;
    private static final byte HEADER_TX_FORGET_REQUEST = 18;
    private static final byte HEADER_TX_BEFORE_COMPLETION_REQUEST = 19;
    private final ChannelAssociation channelAssociation;
    private final DeploymentRepository deploymentRepository;
    private final EJBRemoteTransactionsRepository transactionsRepository;
    private final MarshallerFactory marshallerFactory;
    private final ExecutorService executorService;
    private final RegistryCollector<String, List<ClientMapping>> clientMappingRegistryCollector;
    private final Set<ClusterTopologyUpdateListener> clusterTopologyUpdateListeners = Collections.synchronizedSet(new HashSet());

    public VersionOneProtocolChannelReceiver(ChannelAssociation channelAssociation, DeploymentRepository deploymentRepository, EJBRemoteTransactionsRepository transactionsRepository, RegistryCollector<String, List<ClientMapping>> clientMappingRegistryCollector, MarshallerFactory marshallerFactory, ExecutorService executorService) {
        this.marshallerFactory = marshallerFactory;
        this.channelAssociation = channelAssociation;
        this.executorService = executorService;
        this.deploymentRepository = deploymentRepository;
        this.transactionsRepository = transactionsRepository;
        this.clientMappingRegistryCollector = clientMappingRegistryCollector;
    }

    public void startReceiving() {
        Channel channel = this.channelAssociation.getChannel();
        channel.addCloseHandler((CloseHandler)new ChannelCloseHandler());
        channel.receiveMessage((Channel.Receiver)this);
        this.deploymentRepository.addListener(this);
        this.clientMappingRegistryCollector.addListener((RegistryCollector.Listener)this);
        Collection clusters = this.clientMappingRegistryCollector.getRegistries();
        try {
            this.sendNewClusterFormedMessage(clusters);
        }
        catch (IOException ioe) {
            EjbLogger.EJB3_LOGGER.failedToSendClusterFormationMessageToClient(ioe, channel);
        }
        for (Registry cluster : clusters) {
            ClusterTopologyUpdateListener clusterTopologyUpdateListener = new ClusterTopologyUpdateListener((Registry<String, List<ClientMapping>>)cluster, this);
            cluster.addListener((Registry.Listener)clusterTopologyUpdateListener);
            this.clusterTopologyUpdateListeners.add(clusterTopologyUpdateListener);
        }
    }

    public void handleError(Channel channel, IOException error) {
        try {
            channel.close();
        }
        catch (IOException e) {
            throw EjbMessages.MESSAGES.couldNotCloseChannel(e);
        }
        finally {
            this.cleanupOnChannelDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEnd(Channel channel) {
        try {
            channel.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.cleanupOnChannelDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Channel channel, MessageInputStream messageInputStream) {
        try {
            int header = messageInputStream.read();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Got message with header 0x" + Integer.toHexString(header) + " on channel " + channel));
            }
            AbstractMessageHandler messageHandler = null;
            switch (header) {
                case 3: {
                    messageHandler = new MethodInvocationMessageHandler(this.deploymentRepository, this.marshallerFactory, this.executorService);
                    break;
                }
                case 1: {
                    messageHandler = new SessionOpenRequestHandler(this.deploymentRepository, this.marshallerFactory, this.executorService);
                    break;
                }
                case 15: {
                    messageHandler = new TransactionRequestHandler(this.transactionsRepository, this.marshallerFactory, this.executorService, TransactionRequestHandler.TransactionRequestType.COMMIT);
                    break;
                }
                case 16: {
                    messageHandler = new TransactionRequestHandler(this.transactionsRepository, this.marshallerFactory, this.executorService, TransactionRequestHandler.TransactionRequestType.ROLLBACK);
                    break;
                }
                case 18: {
                    messageHandler = new TransactionRequestHandler(this.transactionsRepository, this.marshallerFactory, this.executorService, TransactionRequestHandler.TransactionRequestType.FORGET);
                    break;
                }
                case 17: {
                    messageHandler = new TransactionRequestHandler(this.transactionsRepository, this.marshallerFactory, this.executorService, TransactionRequestHandler.TransactionRequestType.PREPARE);
                    break;
                }
                case 19: {
                    messageHandler = new TransactionRequestHandler(this.transactionsRepository, this.marshallerFactory, this.executorService, TransactionRequestHandler.TransactionRequestType.BEFORE_COMPLETION);
                    break;
                }
                default: {
                    logger.warn((Object)("Received unsupported message header 0x" + Integer.toHexString(header) + " on channel " + channel));
                    return;
                }
            }
            messageHandler.processMessage(this.channelAssociation, messageInputStream);
            channel.receiveMessage((Channel.Receiver)this);
        }
        catch (IOException e) {
            logger.errorf((Throwable)e, "Exception on channel %s from message %s", (Object)channel, (Object)messageInputStream);
            IoUtils.safeClose((Closeable)channel);
        }
        finally {
            IoUtils.safeClose((Closeable)messageInputStream);
        }
    }

    @Override
    public void listenerAdded(DeploymentRepository repository) {
        Map<DeploymentModuleIdentifier, ModuleDeployment> availableModules = this.deploymentRepository.getModules();
        if (availableModules != null && !availableModules.isEmpty()) {
            try {
                logger.debug((Object)("Sending initial module availability message, containing " + availableModules.size() + " module(s) to channel " + this.channelAssociation.getChannel()));
                this.sendModuleAvailability(availableModules.keySet().toArray(new DeploymentModuleIdentifier[availableModules.size()]));
            }
            catch (IOException e) {
                logger.warn((Object)("Could not send initial module availability report to channel " + this.channelAssociation.getChannel()), (Throwable)e);
            }
        }
    }

    @Override
    public void deploymentAvailable(DeploymentModuleIdentifier deploymentModuleIdentifier, ModuleDeployment moduleDeployment) {
        try {
            this.sendModuleAvailability(new DeploymentModuleIdentifier[]{deploymentModuleIdentifier});
        }
        catch (IOException e) {
            EjbLogger.EJB3_LOGGER.failedToSendModuleAvailabilityMessageToClient(e, deploymentModuleIdentifier, this.channelAssociation.getChannel());
        }
    }

    @Override
    public void deploymentRemoved(DeploymentModuleIdentifier deploymentModuleIdentifier) {
        try {
            this.sendModuleUnAvailability(new DeploymentModuleIdentifier[]{deploymentModuleIdentifier});
        }
        catch (IOException e) {
            EjbLogger.EJB3_LOGGER.failedToSendModuleUnavailabilityMessageToClient(e, deploymentModuleIdentifier, this.channelAssociation.getChannel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendModuleAvailability(DeploymentModuleIdentifier[] availableModules) throws IOException {
        MessageOutputStream messageOutputStream;
        try {
            messageOutputStream = this.channelAssociation.acquireChannelMessageOutputStream();
        }
        catch (Exception e) {
            throw EjbMessages.MESSAGES.failedToOpenMessageOutputStream(e);
        }
        DataOutputStream outputStream = new DataOutputStream((OutputStream)messageOutputStream);
        ModuleAvailabilityWriter moduleAvailabilityWriter = new ModuleAvailabilityWriter();
        try {
            moduleAvailabilityWriter.writeModuleAvailability(outputStream, availableModules);
        }
        finally {
            this.channelAssociation.releaseChannelMessageOutputStream(messageOutputStream);
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendModuleUnAvailability(DeploymentModuleIdentifier[] availableModules) throws IOException {
        MessageOutputStream messageOutputStream;
        try {
            messageOutputStream = this.channelAssociation.acquireChannelMessageOutputStream();
        }
        catch (Exception e) {
            throw EjbMessages.MESSAGES.failedToOpenMessageOutputStream(e);
        }
        DataOutputStream outputStream = new DataOutputStream((OutputStream)messageOutputStream);
        ModuleAvailabilityWriter moduleAvailabilityWriter = new ModuleAvailabilityWriter();
        try {
            moduleAvailabilityWriter.writeModuleUnAvailability(outputStream, availableModules);
        }
        finally {
            this.channelAssociation.releaseChannelMessageOutputStream(messageOutputStream);
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registryAdded(Registry<String, List<ClientMapping>> cluster) {
        try {
            logger.debug((Object)("Received new cluster formation notification for cluster " + cluster.getName()));
            this.sendNewClusterFormedMessage(Collections.singleton(cluster));
        }
        catch (IOException ioe) {
            EjbLogger.EJB3_LOGGER.failedToSendClusterFormationMessageToClient(ioe, cluster.getName(), this.channelAssociation.getChannel());
        }
        finally {
            ClusterTopologyUpdateListener clusterTopologyUpdateListener = new ClusterTopologyUpdateListener(cluster, this);
            cluster.addListener((Registry.Listener)clusterTopologyUpdateListener);
            this.clusterTopologyUpdateListeners.add(clusterTopologyUpdateListener);
        }
    }

    public void registryRemoved(Registry<String, List<ClientMapping>> registry) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNewClusterFormedMessage(Collection<Registry<String, List<ClientMapping>>> clientMappingRegistries) throws IOException {
        MessageOutputStream messageOutputStream;
        try {
            messageOutputStream = this.channelAssociation.acquireChannelMessageOutputStream();
        }
        catch (Exception e) {
            throw EjbMessages.MESSAGES.failedToOpenMessageOutputStream(e);
        }
        DataOutputStream outputStream = new DataOutputStream((OutputStream)messageOutputStream);
        ClusterTopologyWriter clusterTopologyWriter = new ClusterTopologyWriter();
        try {
            logger.debug((Object)("Writing out cluster formation message for " + clientMappingRegistries.size() + " clusters, to channel " + this.channelAssociation.getChannel()));
            clusterTopologyWriter.writeCompleteClusterTopology(outputStream, clientMappingRegistries);
        }
        finally {
            this.channelAssociation.releaseChannelMessageOutputStream(messageOutputStream);
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendClusterRemovedMessage(Registry<String, List<ClientMapping>> registry) throws IOException {
        MessageOutputStream messageOutputStream;
        try {
            messageOutputStream = this.channelAssociation.acquireChannelMessageOutputStream();
        }
        catch (Exception e) {
            throw EjbMessages.MESSAGES.failedToOpenMessageOutputStream(e);
        }
        DataOutputStream outputStream = new DataOutputStream((OutputStream)messageOutputStream);
        ClusterTopologyWriter clusterTopologyWriter = new ClusterTopologyWriter();
        try {
            logger.debug((Object)("Cluster " + registry.getName() + " removed, writing cluster removal message to channel " + this.channelAssociation.getChannel()));
            clusterTopologyWriter.writeClusterRemoved(outputStream, Collections.singleton(registry));
        }
        finally {
            this.channelAssociation.releaseChannelMessageOutputStream(messageOutputStream);
            outputStream.close();
        }
    }

    private void cleanupOnChannelDown() {
        for (ClusterTopologyUpdateListener clusterTopologyUpdateListener : this.clusterTopologyUpdateListeners) {
            clusterTopologyUpdateListener.unregisterListener();
        }
        this.deploymentRepository.removeListener(this);
        this.clientMappingRegistryCollector.removeListener((RegistryCollector.Listener)this);
    }

    private class ClusterTopologyUpdateListener
    implements Registry.Listener<String, List<ClientMapping>> {
        private final String clusterName;
        private final VersionOneProtocolChannelReceiver channelReceiver;
        private final Registry<String, List<ClientMapping>> cluster;

        ClusterTopologyUpdateListener(Registry<String, List<ClientMapping>> cluster, VersionOneProtocolChannelReceiver channelReceiver) {
            this.channelReceiver = channelReceiver;
            this.clusterName = cluster.getName();
            this.cluster = cluster;
        }

        public void addedEntries(Map<String, List<ClientMapping>> added) {
            try {
                this.sendClusterNodesAdded(added);
            }
            catch (IOException ioe) {
                EjbLogger.EJB3_LOGGER.failedToSendClusterNodeAdditionMessageToClient(ioe, VersionOneProtocolChannelReceiver.this.channelAssociation.getChannel());
            }
        }

        public void updatedEntries(Map<String, List<ClientMapping>> updated) {
        }

        public void removedEntries(Set<String> removed) {
            try {
                this.sendClusterNodesRemoved(removed);
            }
            catch (IOException ioe) {
                EjbLogger.EJB3_LOGGER.failedToSendClusterNodeRemovalMessageToClient(ioe, VersionOneProtocolChannelReceiver.this.channelAssociation.getChannel());
            }
        }

        private void unregisterListener() {
            this.cluster.removeListener((Registry.Listener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendClusterNodesRemoved(Set<String> removedNodes) throws IOException {
            MessageOutputStream messageOutputStream;
            try {
                messageOutputStream = VersionOneProtocolChannelReceiver.this.channelAssociation.acquireChannelMessageOutputStream();
            }
            catch (Exception e) {
                throw EjbMessages.MESSAGES.failedToOpenMessageOutputStream(e);
            }
            DataOutputStream outputStream = new DataOutputStream((OutputStream)messageOutputStream);
            ClusterTopologyWriter clusterTopologyWriter = new ClusterTopologyWriter();
            try {
                logger.debug((Object)(removedNodes.size() + " nodes removed from cluster " + this.clusterName + ", writing a protocol message to channel " + this.channelReceiver.channelAssociation.getChannel()));
                clusterTopologyWriter.writeNodesRemoved(outputStream, this.clusterName, removedNodes);
            }
            finally {
                VersionOneProtocolChannelReceiver.this.channelAssociation.releaseChannelMessageOutputStream(messageOutputStream);
                outputStream.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendClusterNodesAdded(Map<String, List<ClientMapping>> addedNodes) throws IOException {
            MessageOutputStream messageOutputStream;
            try {
                messageOutputStream = VersionOneProtocolChannelReceiver.this.channelAssociation.acquireChannelMessageOutputStream();
            }
            catch (Exception e) {
                throw EjbMessages.MESSAGES.failedToOpenMessageOutputStream(e);
            }
            DataOutputStream outputStream = new DataOutputStream((OutputStream)messageOutputStream);
            ClusterTopologyWriter clusterTopologyWriter = new ClusterTopologyWriter();
            try {
                logger.debug((Object)(addedNodes.size() + " nodes added to cluster " + this.clusterName + ", writing a protocol message to channel " + this.channelReceiver.channelAssociation.getChannel()));
                clusterTopologyWriter.writeNewNodesAdded(outputStream, this.clusterName, addedNodes);
            }
            finally {
                VersionOneProtocolChannelReceiver.this.channelAssociation.releaseChannelMessageOutputStream(messageOutputStream);
                outputStream.close();
            }
        }
    }

    private class ChannelCloseHandler
    implements CloseHandler<Channel> {
        private ChannelCloseHandler() {
        }

        public void handleClose(Channel closedChannel, IOException exception) {
            logger.debug((Object)("Channel " + closedChannel + " closed"));
            VersionOneProtocolChannelReceiver.this.cleanupOnChannelDown();
        }
    }
}

