/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.singleton;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagementType;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentCreateServiceFactory;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ee.component.ViewInstanceFactory;
import org.jboss.as.ee.component.serialization.WriteReplaceInterface;
import org.jboss.as.ejb3.component.DefaultAccessTimeoutService;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.interceptors.ComponentTypeIdentityInterceptorFactory;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.component.session.StatelessRemoteViewInstanceFactory;
import org.jboss.as.ejb3.component.session.StatelessWriteReplaceInterceptor;
import org.jboss.as.ejb3.component.singleton.SingletonComponentCreateServiceFactory;
import org.jboss.as.ejb3.component.singleton.SingletonComponentInstanceAssociationInterceptor;
import org.jboss.as.ejb3.concurrency.ContainerManagedConcurrencyInterceptorFactory;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.ejb3.tx.EjbBMTInterceptor;
import org.jboss.as.ejb3.tx.SingletonLifecycleCMTTxInterceptor;
import org.jboss.as.ejb3.tx.TimerCMTTxInterceptor;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassIndex;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceName;

public class SingletonComponentDescription
extends SessionBeanComponentDescription {
    private boolean initOnStartup;
    private final List<ServiceName> dependsOn = new ArrayList<ServiceName>();
    private DefaultAccessTimeoutService defaultAccessTimeoutProvider;

    public SingletonComponentDescription(String componentName, String componentClassName, EjbJarDescription ejbJarDescription, ServiceName deploymentUnitServiceName, SessionBeanMetaData descriptorData) {
        super(componentName, componentClassName, ejbJarDescription, deploymentUnitServiceName, descriptorData);
        this.addConcurrencyManagementInterceptor();
        this.getConfigurators().add(new ComponentConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                configuration.addTimeoutViewInterceptor(SingletonComponentInstanceAssociationInterceptor.FACTORY, 1792);
            }
        });
    }

    public ComponentConfiguration createConfiguration(ClassIndex classIndex, ClassLoader moduleClassLoder, ModuleLoader moduleLoader) {
        ComponentConfiguration singletonComponentConfiguration = new ComponentConfiguration((ComponentDescription)this, classIndex, moduleClassLoder, moduleLoader);
        singletonComponentConfiguration.setComponentCreateServiceFactory((ComponentCreateServiceFactory)new SingletonComponentCreateServiceFactory(this.isInitOnStartup(), this.dependsOn));
        if (this.getTransactionManagementType().equals((Object)TransactionManagementType.CONTAINER)) {
            this.getConfigurators().add(new ComponentConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                    configuration.addPostConstructInterceptor((InterceptorFactory)new SingletonLifecycleCMTTxInterceptor.Factory(TransactionAttributeType.REQUIRES_NEW), 768);
                    configuration.addPreDestroyInterceptor((InterceptorFactory)new SingletonLifecycleCMTTxInterceptor.Factory(TransactionAttributeType.REQUIRES_NEW), 768);
                    if (description.isPassivationApplicable()) {
                        configuration.addPrePassivateInterceptor((InterceptorFactory)new SingletonLifecycleCMTTxInterceptor.Factory(TransactionAttributeType.REQUIRES_NEW), 768);
                        configuration.addPostActivateInterceptor((InterceptorFactory)new SingletonLifecycleCMTTxInterceptor.Factory(TransactionAttributeType.REQUIRES_NEW), 768);
                    }
                    configuration.addTimeoutViewInterceptor(TimerCMTTxInterceptor.FACTORY, 1280);
                }
            });
        } else {
            this.getConfigurators().add(new ComponentConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                    configuration.addPostConstructInterceptor(EjbBMTInterceptor.FACTORY, 768);
                    configuration.addPreDestroyInterceptor(EjbBMTInterceptor.FACTORY, 768);
                    configuration.addComponentInterceptor(EjbBMTInterceptor.FACTORY, 1312, false);
                }
            });
        }
        return singletonComponentConfiguration;
    }

    public boolean isInitOnStartup() {
        return this.initOnStartup;
    }

    public void initOnStartup() {
        this.initOnStartup = true;
    }

    @Override
    public boolean allowsConcurrentAccess() {
        return true;
    }

    @Override
    public SessionBeanComponentDescription.SessionBeanType getSessionBeanType() {
        return SessionBeanComponentDescription.SessionBeanType.SINGLETON;
    }

    @Override
    protected void setupViewInterceptors(EJBViewDescription view) {
        EJBViewDescription ejbViewDescription;
        super.setupViewInterceptors(view);
        this.addViewSerializationInterceptor(view);
        view.getConfigurators().addFirst(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                for (Method method : configuration.getProxyFactory().getCachedMethods()) {
                    if ((!method.getName().equals("hashCode") || method.getParameterTypes().length != 0) && (!method.getName().equals("equals") || method.getParameterTypes().length != 1 || method.getParameterTypes()[0] != Object.class)) continue;
                    configuration.addClientInterceptor(method, (InterceptorFactory)ComponentTypeIdentityInterceptorFactory.INSTANCE, 1024);
                }
                configuration.addViewInterceptor(SingletonComponentInstanceAssociationInterceptor.FACTORY, 1792);
            }
        });
        if (view instanceof EJBViewDescription && (ejbViewDescription = view).getMethodIntf() == MethodIntf.REMOTE) {
            view.getConfigurators().add(new ViewConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                    String earApplicationName = componentConfiguration.getComponentDescription().getModuleDescription().getEarApplicationName();
                    configuration.setViewInstanceFactory((ViewInstanceFactory)new StatelessRemoteViewInstanceFactory(earApplicationName, componentConfiguration.getModuleName(), componentConfiguration.getComponentDescription().getModuleDescription().getDistinctName(), componentConfiguration.getComponentName()));
                }
            });
        }
    }

    private void addViewSerializationInterceptor(ViewDescription view) {
        view.setSerializable(true);
        view.setUseWriteReplace(true);
        view.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                DeploymentReflectionIndex index = (DeploymentReflectionIndex)context.getDeploymentUnit().getAttachment(Attachments.REFLECTION_INDEX);
                ClassReflectionIndex classIndex = index.getClassIndex(WriteReplaceInterface.class);
                for (Method method : classIndex.getMethods()) {
                    configuration.addClientInterceptor(method, (InterceptorFactory)new StatelessWriteReplaceInterceptor.Factory(configuration.getViewServiceName().getCanonicalName()), 1280);
                }
            }
        });
    }

    @Override
    protected ViewConfigurator getSessionBeanObjectViewConfigurator() {
        throw new RuntimeException("Singleton beans cannot have EJB 2.x views");
    }

    private void addConcurrencyManagementInterceptor() {
        this.getConfigurators().add(new ComponentConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                SingletonComponentDescription singletonComponentDescription = (SingletonComponentDescription)description;
                if (singletonComponentDescription.getConcurrencyManagementType() == ConcurrencyManagementType.BEAN) {
                    return;
                }
                configuration.addComponentInterceptor((InterceptorFactory)ContainerManagedConcurrencyInterceptorFactory.INSTANCE, 1792, false);
            }
        });
    }

    public List<ServiceName> getDependsOn() {
        return this.dependsOn;
    }

    public boolean isTimerServiceApplicable() {
        return true;
    }
}

