/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntryStoreSourceService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

public abstract class PassivationStoreAdd
extends AbstractAddStepHandler {
    private final AttributeDefinition[] attributes;

    PassivationStoreAdd(AttributeDefinition ... attributes) {
        this.attributes = attributes;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        String name = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
        model.get("name").set(name);
        for (AttributeDefinition attr : this.attributes) {
            attr.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> serviceControllers) throws OperationFailedException {
        serviceControllers.add(this.installRuntimeService(context, model, verificationHandler));
    }

    ServiceController<?> installRuntimeService(OperationContext context, ModelNode model, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        BackingCacheEntryStoreSourceService<?, ?, ?, ?> service = this.createService(model);
        Object config = service.getValue();
        if (model.hasDefined("idle-timeout")) {
            config.setIdleTimeout(model.get("idle-timeout").asLong());
        }
        if (model.hasDefined("idle-timeout-unit")) {
            config.setIdleTimeoutUnit(TimeUnit.valueOf(model.get("idle-timeout-unit").asString()));
        }
        if (model.hasDefined("max-size")) {
            config.setMaxSize(model.get("max-size").asInt());
        }
        ServiceBuilder<?> builder = service.build(context.getServiceTarget());
        if (verificationHandler != null) {
            builder.addListener((ServiceListener)verificationHandler);
        }
        return builder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }

    protected abstract BackingCacheEntryStoreSourceService<?, ?, ?, ?> createService(ModelNode var1);
}

