/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.ejb3.cache.CacheFactoryService;
import org.jboss.as.ejb3.subsystem.CacheFactoryAdd;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;

public class CacheFactoryRemove
extends AbstractRemoveStepHandler {
    private final CacheFactoryAdd addHandler;

    CacheFactoryRemove(CacheFactoryAdd addHandler) {
        this.addHandler = addHandler;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (context.isResourceServiceRestartAllowed()) {
            this.removeRuntimeService(context, operation);
        } else {
            context.reloadRequired();
        }
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (context.isResourceServiceRestartAllowed()) {
            this.addHandler.installRuntimeService(context, model, null);
        } else {
            context.revertReloadRequired();
        }
    }

    void removeRuntimeService(OperationContext context, ModelNode operation) {
        String name = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
        ServiceName serviceName = CacheFactoryService.getServiceName(name);
        context.removeService(serviceName);
    }
}

