/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import java.lang.reflect.Method;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.deployment.ApplicableMethodInformation;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.security.EJBMethodSecurityAttribute;
import org.jboss.as.ejb3.security.EjbJaccConfig;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassIndex;
import org.jboss.as.server.deployment.reflect.DeploymentClassIndex;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;

public class EjbJaccConfigurator
implements ComponentConfigurator {
    public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
        SessionBeanComponentDescription session;
        DeploymentUnit deploymentUnit = context.getDeploymentUnit();
        DeploymentClassIndex classIndex = (DeploymentClassIndex)deploymentUnit.getAttachment(Attachments.CLASS_INDEX);
        EJBComponentDescription component = (EJBComponentDescription)((Object)EJBComponentDescription.class.cast(description));
        EjbJaccConfig config = new EjbJaccConfig();
        context.getDeploymentUnit().addToAttachmentList(EjbDeploymentAttachmentKeys.JACC_PERMISSIONS, (Object)config);
        String ejbClassName = component.getEJBClassName();
        String ejbName = component.getEJBName();
        boolean denyOnAllViews = true;
        boolean permitOnAllViews = true;
        ArrayList<EJBMethodPermission> permissions = new ArrayList<EJBMethodPermission>();
        ArrayList<EJBMethodPermission> uncheckedPermissions = new ArrayList<EJBMethodPermission>();
        ApplicableMethodInformation<EJBMethodSecurityAttribute> perms = component.getMethodPermissions();
        for (ViewDescription view : component.getViews()) {
            EJBMethodPermission p;
            ClassIndex viewClass;
            String viewClassName = view.getViewClassName();
            try {
                viewClass = classIndex.classIndex(viewClassName);
            }
            catch (ClassNotFoundException e) {
                throw EjbMessages.MESSAGES.failToLoadEjbViewClass(e);
            }
            MethodIntf methodIntf = ((EJBViewDescription)view).getMethodIntf();
            MethodInterfaceType type = this.getMethodInterfaceType(methodIntf);
            EJBMethodSecurityAttribute classLevel = perms.getClassLevelAttribute(ejbClassName);
            if (classLevel != null && !classLevel.isDenyAll()) {
                denyOnAllViews = false;
            } else {
                p = new EJBMethodPermission(ejbName, null, type.name(), null);
                permissions.add(p);
            }
            if (classLevel != null && !classLevel.isPermitAll()) {
                permitOnAllViews = false;
            } else {
                p = new EJBMethodPermission(ejbName, null, type.name(), null);
                uncheckedPermissions.add(p);
            }
            if (classLevel != null) {
                for (String role : classLevel.getRolesAllowed()) {
                    config.addRole(role, (Permission)new EJBMethodPermission(ejbName, null, null, null));
                }
            }
            for (Method method : viewClass.getClassMethods()) {
                MethodIdentifier identifier = MethodIdentifier.getIdentifierForMethod((Method)method);
                EJBMethodSecurityAttribute methodLevel = component.getMethodPermissions().getAttribute(methodIntf, method.getDeclaringClass().getName(), method.getName(), identifier.getParameterTypes());
                if (methodLevel == null) continue;
                EJBMethodPermission p2 = new EJBMethodPermission(ejbName, identifier.getName(), type.name(), identifier.getParameterTypes());
                if (methodLevel.isDenyAll()) {
                    config.addDeny((Permission)p2);
                }
                if (methodLevel.isPermitAll()) {
                    config.addPermit((Permission)p2);
                }
                for (String role : methodLevel.getRolesAllowed()) {
                    config.addRole(role, (Permission)p2);
                }
            }
        }
        if (denyOnAllViews) {
            permissions = new ArrayList();
            permissions.add(new EJBMethodPermission(ejbName, null, null, null));
        }
        for (EJBMethodPermission ejbMethodPermission : permissions) {
            config.addDeny((Permission)ejbMethodPermission);
        }
        if (permitOnAllViews) {
            uncheckedPermissions = new ArrayList();
            uncheckedPermissions.add(new EJBMethodPermission(ejbName, null, null, null));
        }
        for (EJBMethodPermission ejbMethodPermission : uncheckedPermissions) {
            config.addPermit((Permission)ejbMethodPermission);
        }
        Map<String, Collection<String>> securityRoles = component.getSecurityRoleLinks();
        for (Map.Entry<String, Collection<String>> entry : securityRoles.entrySet()) {
            String roleName = entry.getKey();
            for (String roleLink : entry.getValue()) {
                EJBRoleRefPermission p = new EJBRoleRefPermission(ejbName, roleName);
                config.addRole(roleLink, (Permission)p);
            }
        }
        if (component instanceof SessionBeanComponentDescription && (session = (SessionBeanComponentDescription)((Object)SessionBeanComponentDescription.class.cast((Object)component))).isStateful()) {
            EJBMethodPermission p = new EJBMethodPermission(ejbName, "getEJBObject", "Home", null);
            config.addPermit((Permission)p);
        }
    }

    protected MethodInterfaceType getMethodInterfaceType(MethodIntf viewType) {
        switch (viewType) {
            case HOME: {
                return MethodInterfaceType.Home;
            }
            case LOCAL_HOME: {
                return MethodInterfaceType.LocalHome;
            }
            case SERVICE_ENDPOINT: {
                return MethodInterfaceType.ServiceEndpoint;
            }
            case LOCAL: {
                return MethodInterfaceType.Local;
            }
            case REMOTE: {
                return MethodInterfaceType.Remote;
            }
            case TIMER: {
                return MethodInterfaceType.Timer;
            }
            case MESSAGE_ENDPOINT: {
                return MethodInterfaceType.MessageEndpoint;
            }
        }
        return null;
    }
}

