/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ee.component.serialization.WriteReplaceInterface;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.security.AuthorizationInterceptor;
import org.jboss.as.ejb3.security.EJBMethodSecurityAttribute;
import org.jboss.as.ejb3.security.SecurityContextInterceptorFactory;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndexUtil;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.proxy.MethodIdentifier;

public class EJBSecurityViewConfigurator
implements ViewConfigurator {
    public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription viewDescription, ViewConfiguration viewConfiguration) throws DeploymentUnitProcessingException {
        if (!(componentConfiguration.getComponentDescription() instanceof EJBComponentDescription)) {
            throw EjbMessages.MESSAGES.invalidEjbComponent(componentConfiguration.getComponentName(), componentConfiguration.getComponentClass());
        }
        DeploymentReflectionIndex deploymentReflectionIndex = (DeploymentReflectionIndex)context.getDeploymentUnit().getAttachment(Attachments.REFLECTION_INDEX);
        EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)componentConfiguration.getComponentDescription();
        if (!ejbComponentDescription.isSecurityEnabled()) {
            EjbLogger.ROOT_LOGGER.debug("Security is *not* enabled on EJB: " + ejbComponentDescription.getEJBName() + ", no security interceptors will apply");
            return;
        }
        String viewClassName = viewDescription.getViewClassName();
        viewConfiguration.addViewInterceptor((InterceptorFactory)new SecurityContextInterceptorFactory(), 592);
        EJBViewDescription ejbViewDescription = (EJBViewDescription)viewDescription;
        List viewMethods = viewConfiguration.getProxyFactory().getCachedMethods();
        for (Method viewMethod : viewMethods) {
            Method classMethod;
            if (!Modifier.isPublic(viewMethod.getModifiers()) || viewMethod.getDeclaringClass() == WriteReplaceInterface.class) continue;
            EJBMethodSecurityAttribute ejbMethodSecurityMetaData = ejbComponentDescription.getMethodPermissions().getViewAttribute(ejbViewDescription.getMethodIntf(), viewMethod.getName(), MethodIdentifier.getIdentifierForMethod((Method)viewMethod).getParameterTypes());
            if (ejbMethodSecurityMetaData == null) {
                ejbMethodSecurityMetaData = ejbComponentDescription.getMethodPermissions().getViewAttribute(MethodIntf.BEAN, viewMethod.getName(), MethodIdentifier.getIdentifierForMethod((Method)viewMethod).getParameterTypes());
            }
            if (ejbMethodSecurityMetaData == null && (classMethod = ClassReflectionIndexUtil.findMethod((DeploymentReflectionIndex)deploymentReflectionIndex, (Class)componentConfiguration.getComponentClass(), (Method)viewMethod)) != null && (ejbMethodSecurityMetaData = ejbComponentDescription.getMethodPermissions().getAttribute(ejbViewDescription.getMethodIntf(), classMethod.getDeclaringClass().getName(), classMethod.getName(), MethodIdentifier.getIdentifierForMethod((Method)classMethod).getParameterTypes())) == null) {
                ejbMethodSecurityMetaData = ejbComponentDescription.getMethodPermissions().getAttribute(MethodIntf.BEAN, classMethod.getDeclaringClass().getName(), classMethod.getName(), MethodIdentifier.getIdentifierForMethod((Method)classMethod).getParameterTypes());
            }
            if (ejbMethodSecurityMetaData == null) continue;
            AuthorizationInterceptor authorizationInterceptor = new AuthorizationInterceptor(ejbMethodSecurityMetaData, viewClassName, viewMethod);
            viewConfiguration.addViewInterceptor(viewMethod, (InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)authorizationInterceptor), 768);
        }
    }
}

