/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.metadata.MethodAnnotationAggregator;
import org.jboss.as.ee.metadata.RuntimeAnnotationInformation;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.processors.merging.AbstractMergingProcessor;
import org.jboss.as.ejb3.security.EJBMethodSecurityAttribute;
import org.jboss.as.ejb3.security.EjbJaccConfigurator;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.spec.AssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.ejb.spec.ExcludeListMetaData;
import org.jboss.metadata.ejb.spec.MethodMetaData;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
import org.jboss.metadata.ejb.spec.MethodPermissionMetaData;
import org.jboss.metadata.ejb.spec.MethodPermissionsMetaData;
import org.jboss.metadata.ejb.spec.MethodsMetaData;

public class MethodPermissionsMergingProcessor
extends AbstractMergingProcessor<EJBComponentDescription> {
    private static final Logger logger = Logger.getLogger(MethodPermissionsMergingProcessor.class);

    public MethodPermissionsMergingProcessor() {
        super(EJBComponentDescription.class);
    }

    @Override
    protected void handleAnnotations(DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, EJBComponentDescription description) throws DeploymentUnitProcessingException {
        RuntimeAnnotationInformation permitData = MethodAnnotationAggregator.runtimeAnnotationInformation(componentClass, (EEApplicationClasses)applicationClasses, (DeploymentReflectionIndex)deploymentReflectionIndex, PermitAll.class);
        for (Map.Entry entry : permitData.getClassAnnotations().entrySet()) {
            description.getMethodPermissions().setAttribute(null, (String)entry.getKey(), EJBMethodSecurityAttribute.permitAll());
        }
        for (Map.Entry entry : permitData.getMethodAnnotations().entrySet()) {
            Method method = (Method)entry.getKey();
            MethodIdentifier identifier = MethodIdentifier.getIdentifierForMethod((Method)method);
            description.getMethodPermissions().setAttribute(null, EJBMethodSecurityAttribute.permitAll(), method.getDeclaringClass().getName(), method.getName(), identifier.getParameterTypes());
        }
        RuntimeAnnotationInformation data = MethodAnnotationAggregator.runtimeAnnotationInformation(componentClass, (EEApplicationClasses)applicationClasses, (DeploymentReflectionIndex)deploymentReflectionIndex, RolesAllowed.class);
        for (Map.Entry entry : data.getClassAnnotations().entrySet()) {
            description.getMethodPermissions().setAttribute(null, (String)entry.getKey(), EJBMethodSecurityAttribute.rolesAllowed(new HashSet<Object>(Arrays.asList((Object[])((List)entry.getValue()).get(0)))));
        }
        for (Map.Entry entry : data.getMethodAnnotations().entrySet()) {
            Method method = (Method)entry.getKey();
            MethodIdentifier identifier = MethodIdentifier.getIdentifierForMethod((Method)method);
            description.getMethodPermissions().setAttribute(null, EJBMethodSecurityAttribute.rolesAllowed(new HashSet<Object>(Arrays.asList((Object[])((List)entry.getValue()).get(0)))), method.getDeclaringClass().getName(), method.getName(), identifier.getParameterTypes());
        }
        RuntimeAnnotationInformation denyData = MethodAnnotationAggregator.runtimeAnnotationInformation(componentClass, (EEApplicationClasses)applicationClasses, (DeploymentReflectionIndex)deploymentReflectionIndex, DenyAll.class);
        for (Map.Entry entry : denyData.getClassAnnotations().entrySet()) {
            description.getMethodPermissions().setAttribute(null, (String)entry.getKey(), EJBMethodSecurityAttribute.denyAll());
        }
        for (Map.Entry entry : denyData.getMethodAnnotations().entrySet()) {
            Method method = (Method)entry.getKey();
            MethodIdentifier identifier = MethodIdentifier.getIdentifierForMethod((Method)method);
            description.getMethodPermissions().setAttribute(null, EJBMethodSecurityAttribute.denyAll(), method.getDeclaringClass().getName(), method.getName(), identifier.getParameterTypes());
        }
    }

    @Override
    protected void handleDeploymentDescriptor(DeploymentUnit deploymentUnit, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, EJBComponentDescription componentConfiguration) throws DeploymentUnitProcessingException {
        AssemblyDescriptorMetaData assemblyDescriptor;
        componentConfiguration.getConfigurators().add(new EjbJaccConfigurator());
        EjbJarMetaData ejbJarMetadata = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        if (ejbJarMetadata != null && (assemblyDescriptor = ejbJarMetadata.getAssemblyDescriptor()) != null) {
            MethodPermissionsMetaData methodPermissions;
            ExcludeListMetaData excludeList = assemblyDescriptor.getExcludeListByEjbName(componentConfiguration.getEJBName());
            if (excludeList != null && excludeList.getMethods() != null) {
                for (MethodMetaData method : excludeList.getMethods()) {
                    String methodName = method.getMethodName();
                    MethodIntf methodIntf = this.getMethodIntf(method.getMethodIntf());
                    if (methodName.equals("*")) {
                        componentConfiguration.getMethodPermissions().setAttribute(methodIntf, null, EJBMethodSecurityAttribute.denyAll());
                        continue;
                    }
                    MethodParametersMetaData methodParams = method.getMethodParams();
                    if (methodParams == null) {
                        componentConfiguration.getMethodPermissions().setAttribute(methodIntf, EJBMethodSecurityAttribute.denyAll(), methodName);
                        continue;
                    }
                    componentConfiguration.getMethodPermissions().setAttribute(methodIntf, EJBMethodSecurityAttribute.denyAll(), null, methodName, this.getMethodParams(methodParams));
                }
            }
            if ((methodPermissions = assemblyDescriptor.getMethodPermissionsByEjbName(componentConfiguration.getEJBName())) != null) {
                for (MethodPermissionMetaData methodPermissionMetaData : methodPermissions) {
                    MethodsMetaData methods = methodPermissionMetaData.getMethods();
                    for (MethodMetaData method : methods) {
                        EJBMethodSecurityAttribute existingRoles;
                        EJBMethodSecurityAttribute ejbMethodSecurityMetaData = methodPermissionMetaData.isNotChecked() ? EJBMethodSecurityAttribute.permitAll() : EJBMethodSecurityAttribute.rolesAllowed(methodPermissionMetaData.getRoles());
                        String methodName = method.getMethodName();
                        MethodIntf methodIntf = this.getMethodIntf(method.getMethodIntf());
                        if (methodName.equals("*")) {
                            EJBMethodSecurityAttribute existingRoles2 = componentConfiguration.getMethodPermissions().getAttributeStyle1(methodIntf, null);
                            ejbMethodSecurityMetaData = this.mergeExistingRoles(ejbMethodSecurityMetaData, existingRoles2);
                            componentConfiguration.getMethodPermissions().setAttribute(methodIntf, null, ejbMethodSecurityMetaData);
                            continue;
                        }
                        MethodParametersMetaData methodParams = method.getMethodParams();
                        if (methodParams == null) {
                            existingRoles = componentConfiguration.getMethodPermissions().getAttributeStyle2(methodIntf, methodName);
                            ejbMethodSecurityMetaData = this.mergeExistingRoles(ejbMethodSecurityMetaData, existingRoles);
                            componentConfiguration.getMethodPermissions().setAttribute(methodIntf, ejbMethodSecurityMetaData, methodName);
                            continue;
                        }
                        existingRoles = componentConfiguration.getMethodPermissions().getAttributeStyle3(methodIntf, null, methodName, this.getMethodParams(methodParams));
                        ejbMethodSecurityMetaData = this.mergeExistingRoles(ejbMethodSecurityMetaData, existingRoles);
                        componentConfiguration.getMethodPermissions().setAttribute(methodIntf, ejbMethodSecurityMetaData, null, methodName, this.getMethodParams(methodParams));
                    }
                }
            }
        }
    }

    private EJBMethodSecurityAttribute mergeExistingRoles(EJBMethodSecurityAttribute ejbMethodSecurityMetaData, EJBMethodSecurityAttribute existingRoles) {
        if (existingRoles != null && !existingRoles.getRolesAllowed().isEmpty()) {
            HashSet<String> roles = new HashSet<String>(existingRoles.getRolesAllowed());
            roles.addAll(ejbMethodSecurityMetaData.getRolesAllowed());
            ejbMethodSecurityMetaData = EJBMethodSecurityAttribute.rolesAllowed(roles);
        }
        return ejbMethodSecurityMetaData;
    }
}

