/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import org.jboss.as.ee.metadata.EJBClientDescriptorMetaData;
import org.jboss.as.ee.structure.Attachments;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.remote.DefaultEjbClientContextService;
import org.jboss.as.ejb3.remote.DescriptorBasedEJBClientContextService;
import org.jboss.as.ejb3.remote.LocalEjbReceiver;
import org.jboss.as.remoting.AbstractOutboundConnectionService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class EJBClientDescriptorMetaDataProcessor
implements DeploymentUnitProcessor {
    private static final Logger logger = Logger.getLogger(EJBClientDescriptorMetaDataProcessor.class);

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.getParent() != null) {
            return;
        }
        EJBClientDescriptorMetaData ejbClientDescriptorMetaData = (EJBClientDescriptorMetaData)deploymentUnit.getAttachment(Attachments.EJB_CLIENT_METADATA);
        if (ejbClientDescriptorMetaData == null) {
            logger.debug((Object)("Deployment unit " + deploymentUnit + " doesn't have any EJB client descriptor metadata associated. " + "Falling back on the default " + DefaultEjbClientContextService.DEFAULT_SERVICE_NAME + " EJB client context service"));
            deploymentUnit.putAttachment(EjbDeploymentAttachmentKeys.EJB_CLIENT_CONTEXT_SERVICE_NAME, (Object)DefaultEjbClientContextService.DEFAULT_SERVICE_NAME);
            return;
        }
        ServiceName ejbClientContextServiceName = DescriptorBasedEJBClientContextService.BASE_SERVICE_NAME.append(new String[]{deploymentUnit.getName()});
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        DescriptorBasedEJBClientContextService service = new DescriptorBasedEJBClientContextService();
        ServiceBuilder serviceBuilder = serviceTarget.addService(ejbClientContextServiceName, (Service)service);
        for (String connectionRef : ejbClientDescriptorMetaData.getRemotingReceiverConnectionRefs()) {
            ServiceName connectionDependencyService = AbstractOutboundConnectionService.OUTBOUND_CONNECTION_BASE_SERVICE_NAME.append(new String[]{connectionRef});
            service.addRemotingConnectionDependency((ServiceBuilder<EJBClientContext>)serviceBuilder, connectionDependencyService);
        }
        if (!ejbClientDescriptorMetaData.isLocalReceiverExcluded()) {
            if (ejbClientDescriptorMetaData.isLocalReceiverPassByValue()) {
                serviceBuilder.addDependency(LocalEjbReceiver.BY_VALUE_SERVICE_NAME, LocalEjbReceiver.class, service.getLocalEjbReceiverInjector());
            } else {
                serviceBuilder.addDependency(LocalEjbReceiver.BY_REFERENCE_SERVICE_NAME, LocalEjbReceiver.class, service.getLocalEjbReceiverInjector());
            }
        }
        serviceBuilder.install();
        logger.debug((Object)("Deployment unit " + deploymentUnit + " will use " + ejbClientContextServiceName + " as the EJB client context service"));
        deploymentUnit.putAttachment(EjbDeploymentAttachmentKeys.EJB_CLIENT_CONTEXT_SERVICE_NAME, (Object)ejbClientContextServiceName);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

