/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.entity.interceptors;

import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.ejb3.component.entity.EntityBeanComponent;
import org.jboss.as.ejb3.component.interceptors.AbstractEJBInterceptor;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.logging.Logger;

public class EntityBeanPrimaryKeyInterceptor
extends AbstractEJBInterceptor {
    private static final Logger log = Logger.getLogger(EntityBeanPrimaryKeyInterceptor.class);
    private final AtomicReference<Object> reference;

    public EntityBeanPrimaryKeyInterceptor(AtomicReference<Object> reference) {
        this.reference = reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        try {
            context.putPrivateData(EntityBeanComponent.PRIMARY_KEY_CONTEXT_KEY, this.reference.get());
            Object object = context.proceed();
            return object;
        }
        finally {
            context.putPrivateData(EntityBeanComponent.PRIMARY_KEY_CONTEXT_KEY, null);
        }
    }

    public static class Factory
    implements InterceptorFactory {
        public static final InterceptorFactory INSTANCE = new Factory();

        private Factory() {
        }

        public Interceptor create(InterceptorFactoryContext context) {
            AtomicReference reference = (AtomicReference)context.getContextData().get(EntityBeanComponent.PRIMARY_KEY_CONTEXT_KEY);
            return new EntityBeanPrimaryKeyInterceptor(reference);
        }
    }
}

