/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.entity.interceptors;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.entity.EntityBeanComponent;
import org.jboss.as.ejb3.component.entity.EntityBeanComponentInstance;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.msc.value.InjectedValue;

public class EntityBeanHomeFinderInterceptorFactory
implements InterceptorFactory {
    private final Method finderMethod;
    private final ReturnType returnType;
    private final InjectedValue<ComponentView> viewToCreate = new InjectedValue();

    public EntityBeanHomeFinderInterceptorFactory(Method finderMethod) {
        this.finderMethod = finderMethod;
        this.returnType = Collection.class.isAssignableFrom(finderMethod.getReturnType()) ? ReturnType.COLLECTION : (Enumeration.class.isAssignableFrom(finderMethod.getReturnType()) ? ReturnType.ENUMERATION : ReturnType.SINGLE);
    }

    public Interceptor create(InterceptorFactoryContext context) {
        final EntityBeanComponent component = (EntityBeanComponent)((Object)context.getContextData().get(Component.class));
        return new Interceptor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object processInvocation(InterceptorContext context) throws Exception {
                EntityBeanComponentInstance instance = component.getPool().get();
                try {
                    Object result = EntityBeanHomeFinderInterceptorFactory.this.invokeFind(context, instance);
                    Object object = EntityBeanHomeFinderInterceptorFactory.this.prepareResults(context, result, component);
                    return object;
                }
                finally {
                    component.getPool().release(instance);
                }
            }
        };
    }

    protected Object prepareResults(InterceptorContext context, Object result, EntityBeanComponent component) throws Exception {
        switch (this.returnType) {
            case COLLECTION: {
                Collection keys = (Collection)result;
                HashSet<Object> results = new HashSet<Object>();
                if (keys != null) {
                    for (Object key : keys) {
                        results.add(this.getLocalObject(key));
                    }
                }
                return results;
            }
            case ENUMERATION: {
                Enumeration keys = (Enumeration)result;
                HashSet<Object> results = new HashSet<Object>();
                if (keys != null) {
                    while (keys.hasMoreElements()) {
                        Object key = keys.nextElement();
                        results.add(this.getLocalObject(key));
                    }
                }
                final Iterator iterator = results.iterator();
                return new Enumeration<Object>(){

                    @Override
                    public boolean hasMoreElements() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Object nextElement() {
                        return iterator.next();
                    }
                };
            }
        }
        if (result == null) {
            throw EjbMessages.MESSAGES.couldNotFindEntity(this.finderMethod, Arrays.toString(context.getParameters()));
        }
        return this.getLocalObject(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeFind(InterceptorContext context, EntityBeanComponentInstance instance) throws Exception {
        Method oldMethod = context.getMethod();
        try {
            context.putPrivateData(ComponentInstance.class, (Object)instance);
            context.setMethod(this.finderMethod);
            context.setTarget((Object)instance.getInstance());
            Object object = instance.getInterceptor(this.finderMethod).processInvocation(context);
            return object;
        }
        finally {
            context.setMethod(oldMethod);
            context.setTarget(null);
            context.putPrivateData(ComponentInstance.class, null);
        }
    }

    protected Object getLocalObject(Object result) throws Exception {
        HashMap<Object, Object> create = new HashMap<Object, Object>();
        create.put(EntityBeanComponent.PRIMARY_KEY_CONTEXT_KEY, result);
        return ((ComponentView)this.viewToCreate.getValue()).createInstance(create).getInstance();
    }

    public InjectedValue<ComponentView> getViewToCreate() {
        return this.viewToCreate;
    }

    public ReturnType getReturnType() {
        return this.returnType;
    }

    protected static enum ReturnType {
        COLLECTION,
        ENUMERATION,
        SINGLE;

    }
}

