/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.List;
import javax.ejb.EJB;
import javax.ejb.EJBs;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.FieldInjectionTarget;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.InjectionTarget;
import org.jboss.as.ee.component.LookupInjectionSource;
import org.jboss.as.ee.component.MethodInjectionTarget;
import org.jboss.as.ee.component.ResourceInjectionConfiguration;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.processors.EjbInjectionSource;
import org.jboss.as.ejb3.deployment.processors.EjbLookupInjectionSource;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

public class EjbResourceInjectionAnnotationProcessor
implements DeploymentUnitProcessor {
    private static final DotName EJB_ANNOTATION_NAME = DotName.createSimple((String)EJB.class.getName());
    private static final DotName EJBS_ANNOTATION_NAME = DotName.createSimple((String)EJBs.class.getName());
    private static final Logger logger = Logger.getLogger(EjbResourceInjectionAnnotationProcessor.class);

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        List resourceAnnotations = index.getAnnotations(EJB_ANNOTATION_NAME);
        for (AnnotationInstance annotation : resourceAnnotations) {
            AnnotationTarget annotationTarget = annotation.target();
            EJBResourceWrapper annotationWrapper = new EJBResourceWrapper(annotation);
            if (annotationTarget instanceof FieldInfo) {
                this.processField(deploymentUnit, annotationWrapper, (FieldInfo)annotationTarget, moduleDescription);
                continue;
            }
            if (annotationTarget instanceof MethodInfo) {
                this.processMethod(deploymentUnit, annotationWrapper, (MethodInfo)annotationTarget, moduleDescription);
                continue;
            }
            if (!(annotationTarget instanceof ClassInfo)) continue;
            this.processClass(deploymentUnit, annotationWrapper, (ClassInfo)annotationTarget, moduleDescription);
        }
        List ejbsAnnotations = index.getAnnotations(EJBS_ANNOTATION_NAME);
        for (AnnotationInstance annotation : ejbsAnnotations) {
            AnnotationTarget annotationTarget = annotation.target();
            if (annotationTarget instanceof ClassInfo) {
                AnnotationInstance[] ejbAnnotations;
                AnnotationValue annotationValue = annotation.value();
                for (AnnotationInstance ejbAnnotation : ejbAnnotations = annotationValue.asNestedArray()) {
                    EJBResourceWrapper annotationWrapper = new EJBResourceWrapper(ejbAnnotation);
                    this.processClass(deploymentUnit, annotationWrapper, (ClassInfo)annotationTarget, moduleDescription);
                }
                continue;
            }
            throw new DeploymentUnitProcessingException("EJBs annotation can only be placed on classes " + annotation.target());
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void processField(DeploymentUnit deploymentUnit, EJBResourceWrapper annotation, FieldInfo fieldInfo, EEModuleDescription eeModuleDescription) {
        String fieldName = fieldInfo.name();
        String fieldType = fieldInfo.type().name().toString();
        FieldInjectionTarget targetDescription = new FieldInjectionTarget(fieldInfo.declaringClass().name().toString(), fieldName, fieldType);
        String localContextName = this.isEmpty(annotation.name()) ? fieldInfo.declaringClass().name().toString() + "/" + fieldInfo.name() : annotation.name();
        String beanInterfaceType = this.isEmpty(annotation.beanInterface()) || annotation.beanInterface().equals(Object.class.getName()) ? fieldType : annotation.beanInterface();
        this.process(deploymentUnit, beanInterfaceType, annotation.beanName(), annotation.lookup(), fieldInfo.declaringClass(), (InjectionTarget)targetDescription, localContextName, eeModuleDescription);
    }

    private void processMethod(DeploymentUnit deploymentUnit, EJBResourceWrapper annotation, MethodInfo methodInfo, EEModuleDescription eeModuleDescription) {
        String methodName = methodInfo.name();
        if (!methodName.startsWith("set") || methodInfo.args().length != 1) {
            throw new IllegalArgumentException("@EJB injection target is invalid.  Only setter methods are allowed: " + methodInfo);
        }
        String methodParamType = methodInfo.args()[0].name().toString();
        MethodInjectionTarget targetDescription = new MethodInjectionTarget(methodInfo.declaringClass().name().toString(), methodName, methodParamType);
        String localContextName = this.isEmpty(annotation.name()) ? methodInfo.declaringClass().name().toString() + "/" + methodName.substring(3, 4).toLowerCase() + methodName.substring(4) : annotation.name();
        String beanInterfaceType = this.isEmpty(annotation.beanInterface()) || annotation.beanInterface().equals(Object.class.getName()) ? methodParamType : annotation.beanInterface();
        this.process(deploymentUnit, beanInterfaceType, annotation.beanName(), annotation.lookup(), methodInfo.declaringClass(), (InjectionTarget)targetDescription, localContextName, eeModuleDescription);
    }

    private void processClass(DeploymentUnit deploymentUnit, EJBResourceWrapper annotation, ClassInfo classInfo, EEModuleDescription eeModuleDescription) throws DeploymentUnitProcessingException {
        if (this.isEmpty(annotation.name())) {
            throw new DeploymentUnitProcessingException("@EJB attribute 'name' is required fo class level annotations. Class: " + classInfo.name());
        }
        if (this.isEmpty(annotation.beanInterface())) {
            throw new DeploymentUnitProcessingException("@EJB attribute 'beanInterface' is required fo class level annotations. Class: " + classInfo.name());
        }
        this.process(deploymentUnit, annotation.beanInterface(), annotation.beanName(), annotation.lookup(), classInfo, null, annotation.name(), eeModuleDescription);
    }

    private void process(DeploymentUnit deploymentUnit, String beanInterface, String beanName, String lookup, ClassInfo classInfo, InjectionTarget targetDescription, String localContextName, EEModuleDescription eeModuleDescription) {
        Object valueSource;
        if (!this.isEmpty(lookup) && !this.isEmpty(beanName)) {
            logger.debug((Object)("Both beanName = " + beanName + " and lookup = " + lookup + " have been specified in @EJB annotation." + " lookup will be given preference. Class: " + classInfo.name()));
        }
        EEModuleClassDescription classDescription = eeModuleDescription.addOrGetLocalClassDescription(classInfo.name().toString());
        EjbInjectionSource ejbInjectionSource = null;
        if (!this.isEmpty(lookup)) {
            valueSource = !lookup.startsWith("java:") ? new EjbLookupInjectionSource(lookup, targetDescription.getDeclaredValueClassName()) : new LookupInjectionSource(lookup);
        } else if (!this.isEmpty(beanName)) {
            ejbInjectionSource = new EjbInjectionSource(beanName, beanInterface, localContextName, deploymentUnit);
            valueSource = ejbInjectionSource;
        } else {
            ejbInjectionSource = new EjbInjectionSource(beanInterface, localContextName, deploymentUnit);
            valueSource = ejbInjectionSource;
        }
        if (ejbInjectionSource != null) {
            deploymentUnit.addToAttachmentList(EjbDeploymentAttachmentKeys.EJB_INJECTIONS, (Object)ejbInjectionSource);
        }
        ResourceInjectionConfiguration injectionConfiguration = targetDescription != null ? new ResourceInjectionConfiguration(targetDescription, (InjectionSource)new LookupInjectionSource(localContextName)) : null;
        BindingConfiguration bindingConfiguration = new BindingConfiguration(localContextName, (InjectionSource)valueSource);
        classDescription.getBindingConfigurations().add(bindingConfiguration);
        if (injectionConfiguration != null) {
            classDescription.addResourceInjection(injectionConfiguration);
        }
    }

    private boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    private class EJBResourceWrapper {
        private final String name;
        private final String beanInterface;
        private final String beanName;
        private final String lookup;
        private final String description;

        private EJBResourceWrapper(AnnotationInstance annotation) {
            this.name = this.stringValueOrNull(annotation, "name");
            this.beanInterface = this.classValueOrNull(annotation, "beanInterface");
            this.beanName = this.stringValueOrNull(annotation, "beanName");
            String lookupValue = this.stringValueOrNull(annotation, "lookup");
            if (EjbResourceInjectionAnnotationProcessor.this.isEmpty(lookupValue)) {
                lookupValue = this.stringValueOrNull(annotation, "mappedName");
            }
            this.lookup = lookupValue;
            this.description = this.stringValueOrNull(annotation, "description");
        }

        private String name() {
            return this.name;
        }

        private String beanInterface() {
            return this.beanInterface;
        }

        private String beanName() {
            return this.beanName;
        }

        private String lookup() {
            return this.lookup;
        }

        private String description() {
            return this.description;
        }

        private String stringValueOrNull(AnnotationInstance annotation, String attribute) {
            AnnotationValue value = annotation.value(attribute);
            return value != null ? value.asString() : null;
        }

        private String classValueOrNull(AnnotationInstance annotation, String attribute) {
            AnnotationValue value = annotation.value(attribute);
            return value != null ? value.asClass().name().toString() : null;
        }
    }
}

