/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jboss.as.ee.component.BasicComponent;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.TCCLInterceptor;
import org.jboss.as.ejb3.cache.CacheFactory;
import org.jboss.as.ejb3.cache.CacheInfo;
import org.jboss.as.ejb3.component.DefaultAccessTimeoutService;
import org.jboss.as.ejb3.component.InvokeMethodOnTargetInterceptor;
import org.jboss.as.ejb3.component.interceptors.CurrentInvocationContextInterceptor;
import org.jboss.as.ejb3.component.session.SessionBeanComponentCreateService;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.component.stateful.StatefulRemoveInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import org.jboss.as.ejb3.component.stateful.StatefulSessionSynchronizationInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulTimeoutInfo;
import org.jboss.as.ejb3.deployment.ApplicationExceptions;
import org.jboss.ejb.client.SessionID;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.Interceptors;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.SimpleClassResolver;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.value.InjectedValue;

public class StatefulSessionComponentCreateService
extends SessionBeanComponentCreateService {
    private final InterceptorFactory afterBegin;
    private final Method afterBeginMethod;
    private final InterceptorFactory afterCompletion;
    private final Method afterCompletionMethod;
    private final InterceptorFactory beforeCompletion;
    private final Method beforeCompletionMethod;
    private final Collection<InterceptorFactory> prePassivate;
    private final Collection<InterceptorFactory> postActivate;
    private final StatefulTimeoutInfo statefulTimeout;
    private final CacheInfo cache;
    private final MarshallingConfiguration marshallingConfiguration;
    private final InjectedValue<DefaultAccessTimeoutService> defaultAccessTimeoutService = new InjectedValue();
    private final InterceptorFactory ejb2XRemoveMethod;
    private final InjectedValue<CacheFactory> cacheFactory = new InjectedValue();

    public StatefulSessionComponentCreateService(ComponentConfiguration componentConfiguration, ApplicationExceptions ejbJarConfiguration) {
        super(componentConfiguration, ejbJarConfiguration);
        StatefulComponentDescription componentDescription = (StatefulComponentDescription)componentConfiguration.getComponentDescription();
        ImmediateInterceptorFactory tcclInterceptorFactory = new ImmediateInterceptorFactory((Interceptor)new TCCLInterceptor(componentConfiguration.getModuleClassLoder()));
        InterceptorFactory namespaceContextInterceptorFactory = componentConfiguration.getNamespaceContextInterceptorFactory();
        this.afterBeginMethod = componentDescription.getAfterBegin();
        this.afterBegin = this.afterBeginMethod != null ? Interceptors.getChainedInterceptorFactory((InterceptorFactory[])new InterceptorFactory[]{tcclInterceptorFactory, namespaceContextInterceptorFactory, CurrentInvocationContextInterceptor.FACTORY, StatefulSessionComponentCreateService.invokeMethodOnTarget(this.afterBeginMethod)}) : null;
        this.afterCompletionMethod = componentDescription.getAfterCompletion();
        this.afterCompletion = this.afterCompletionMethod != null ? Interceptors.getChainedInterceptorFactory((InterceptorFactory[])new InterceptorFactory[]{tcclInterceptorFactory, namespaceContextInterceptorFactory, CurrentInvocationContextInterceptor.FACTORY, StatefulSessionComponentCreateService.invokeMethodOnTarget(this.afterCompletionMethod)}) : null;
        this.beforeCompletionMethod = componentDescription.getBeforeCompletion();
        this.beforeCompletion = this.beforeCompletionMethod != null ? Interceptors.getChainedInterceptorFactory((InterceptorFactory[])new InterceptorFactory[]{tcclInterceptorFactory, namespaceContextInterceptorFactory, CurrentInvocationContextInterceptor.FACTORY, StatefulSessionComponentCreateService.invokeMethodOnTarget(this.beforeCompletionMethod)}) : null;
        this.prePassivate = StatefulSessionComponentCreateService.createInterceptorFactories(componentDescription.getPrePassivateMethods(), new InterceptorFactory[]{tcclInterceptorFactory, namespaceContextInterceptorFactory, CurrentInvocationContextInterceptor.FACTORY});
        this.postActivate = StatefulSessionComponentCreateService.createInterceptorFactories(componentDescription.getPostActivateMethods(), new InterceptorFactory[]{tcclInterceptorFactory, namespaceContextInterceptorFactory, CurrentInvocationContextInterceptor.FACTORY});
        this.statefulTimeout = componentDescription.getStatefulTimeout();
        this.ejb2XRemoveMethod = Interceptors.getChainedInterceptorFactory((InterceptorFactory[])new InterceptorFactory[]{StatefulSessionSynchronizationInterceptor.factory(componentDescription.getTransactionManagementType()), new ImmediateInterceptorFactory((Interceptor)new StatefulRemoveInterceptor(false)), Interceptors.getTerminalInterceptorFactory()});
        this.cache = componentDescription.getCache();
        this.marshallingConfiguration = new MarshallingConfiguration();
        this.marshallingConfiguration.setClassResolver((ClassResolver)new SimpleClassResolver(componentConfiguration.getModuleClassLoder()));
    }

    private static Collection<InterceptorFactory> createInterceptorFactories(Collection<Method> methods, InterceptorFactory ... factories) {
        if (methods.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<InterceptorFactory> collection = new ArrayList<InterceptorFactory>(methods.size());
        for (Method method : methods) {
            ArrayList<InterceptorFactory> list = new ArrayList<InterceptorFactory>(factories.length + 1);
            list.addAll(Arrays.asList(factories));
            list.add(StatefulSessionComponentCreateService.invokeMethodOnTarget(method));
            collection.add(Interceptors.getChainedInterceptorFactory(list));
        }
        return collection;
    }

    private static InterceptorFactory invokeMethodOnTarget(Method method) {
        method.setAccessible(true);
        return InvokeMethodOnTargetInterceptor.factory(method);
    }

    protected BasicComponent createComponent() {
        return new StatefulSessionComponent(this);
    }

    public InterceptorFactory getAfterBegin() {
        return this.afterBegin;
    }

    public InterceptorFactory getAfterCompletion() {
        return this.afterCompletion;
    }

    public InterceptorFactory getBeforeCompletion() {
        return this.beforeCompletion;
    }

    public Collection<InterceptorFactory> getPrePassivate() {
        return this.prePassivate;
    }

    public Collection<InterceptorFactory> getPostActivate() {
        return this.postActivate;
    }

    public Method getAfterBeginMethod() {
        return this.afterBeginMethod;
    }

    public Method getAfterCompletionMethod() {
        return this.afterCompletionMethod;
    }

    public Method getBeforeCompletionMethod() {
        return this.beforeCompletionMethod;
    }

    public StatefulTimeoutInfo getStatefulTimeout() {
        return this.statefulTimeout;
    }

    public CacheInfo getCache() {
        return this.cache;
    }

    public MarshallingConfiguration getMarshallingConfiguration() {
        return this.marshallingConfiguration;
    }

    public DefaultAccessTimeoutService getDefaultAccessTimeoutService() {
        return (DefaultAccessTimeoutService)this.defaultAccessTimeoutService.getValue();
    }

    Injector<DefaultAccessTimeoutService> getDefaultAccessTimeoutInjector() {
        return this.defaultAccessTimeoutService;
    }

    public InterceptorFactory getEjb2XRemoveMethod() {
        return this.ejb2XRemoveMethod;
    }

    public CacheFactory<SessionID, StatefulSessionComponentInstance> getCacheFactory() {
        return (CacheFactory)this.cacheFactory.getValue();
    }

    Injector<CacheFactory> getCacheFactoryInjector() {
        return this.cacheFactory;
    }
}

