/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executors;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.ejb3.component.EJBUtilities;
import org.jboss.as.ejb3.component.session.SessionBeanComponent;
import org.jboss.as.ejb3.deployment.processors.ApplicationExceptionAnnotationProcessor;
import org.jboss.as.ejb3.deployment.processors.BusinessViewAnnotationProcessor;
import org.jboss.as.ejb3.deployment.processors.EjbCleanUpProcessor;
import org.jboss.as.ejb3.deployment.processors.EjbContextJndiBindingProcessor;
import org.jboss.as.ejb3.deployment.processors.EjbDependencyDeploymentUnitProcessor;
import org.jboss.as.ejb3.deployment.processors.EjbInjectionResolutionProcessor;
import org.jboss.as.ejb3.deployment.processors.EjbJarConfigurationProcessor;
import org.jboss.as.ejb3.deployment.processors.EjbJarParsingDeploymentUnitProcessor;
import org.jboss.as.ejb3.deployment.processors.EjbJndiBindingsDeploymentUnitProcessor;
import org.jboss.as.ejb3.deployment.processors.EjbRefProcessor;
import org.jboss.as.ejb3.deployment.processors.EjbResourceInjectionAnnotationProcessor;
import org.jboss.as.ejb3.deployment.processors.ImplicitLocalViewProcessor;
import org.jboss.as.ejb3.deployment.processors.MessageDrivenComponentDescriptionFactory;
import org.jboss.as.ejb3.deployment.processors.SessionBeanComponentDescriptionFactory;
import org.jboss.as.ejb3.deployment.processors.TimerServiceJndiBindingProcessor;
import org.jboss.as.ejb3.deployment.processors.annotation.EjbAnnotationProcessor;
import org.jboss.as.ejb3.deployment.processors.dd.AssemblyDescriptorProcessor;
import org.jboss.as.ejb3.deployment.processors.dd.DeploymentDescriptorInterceptorBindingsProcessor;
import org.jboss.as.ejb3.deployment.processors.dd.DeploymentDescriptorMethodProcessor;
import org.jboss.as.ejb3.deployment.processors.dd.InterceptorClassDeploymentDescriptorProcessor;
import org.jboss.as.ejb3.deployment.processors.dd.SecurityRoleRefDDProcessor;
import org.jboss.as.ejb3.deployment.processors.dd.SessionBeanXmlDescriptorProcessor;
import org.jboss.as.ejb3.deployment.processors.merging.AsynchronousMergingProcessor;
import org.jboss.as.ejb3.deployment.processors.merging.ConcurrencyManagementMergingProcessor;
import org.jboss.as.ejb3.deployment.processors.merging.DeclareRolesMergingProcessor;
import org.jboss.as.ejb3.deployment.processors.merging.EjbConcurrencyMergingProcessor;
import org.jboss.as.ejb3.deployment.processors.merging.EjbDependsOnMergingProcessor;
import org.jboss.as.ejb3.deployment.processors.merging.MethodPermissionsMergingProcessor;
import org.jboss.as.ejb3.deployment.processors.merging.RemoveMethodMergingProcessor;
import org.jboss.as.ejb3.deployment.processors.merging.ResourceAdaptorMergingProcessor;
import org.jboss.as.ejb3.deployment.processors.merging.RunAsMergingProcessor;
import org.jboss.as.ejb3.deployment.processors.merging.SecurityDomainMergingProcessor;
import org.jboss.as.ejb3.deployment.processors.merging.SessionSynchronizationMergingProcessor;
import org.jboss.as.ejb3.deployment.processors.merging.StartupMergingProcessor;
import org.jboss.as.ejb3.deployment.processors.merging.StatefulTimeoutMergingProcessor;
import org.jboss.as.ejb3.deployment.processors.merging.TransactionAttributeMergingProcessor;
import org.jboss.as.ejb3.deployment.processors.merging.TransactionManagementMergingProcessor;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemDescriptions;
import org.jboss.as.ejb3.subsystem.SetDefaultMDBPool;
import org.jboss.as.ejb3.subsystem.SetDefaultResourceAdapterName;
import org.jboss.as.ejb3.subsystem.SetDefaultSLSBPool;
import org.jboss.as.security.service.SimpleSecurityManager;
import org.jboss.as.security.service.SimpleSecurityManagerService;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.threads.TimeSpec;
import org.jboss.as.threads.UnboundedQueueThreadPoolService;
import org.jboss.as.txn.TxnServices;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

class EJB3SubsystemAdd
extends AbstractBoottimeAddStepHandler
implements DescriptionProvider {
    static final EJB3SubsystemAdd INSTANCE = new EJB3SubsystemAdd();
    private static final Logger logger = Logger.getLogger(EJB3SubsystemAdd.class);

    private EJB3SubsystemAdd() {
    }

    public ModelNode getModelDescription(Locale locale) {
        return EJB3SubsystemDescriptions.getSubystemAddDescription(locale);
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
        model.get("lite").set(operation.get("lite"));
        model.get("default-mdb-instance-pool").set(operation.get("default-mdb-instance-pool"));
        model.get("default-slsb-instance-pool").set(operation.get("default-slsb-instance-pool"));
        model.get("default-resource-adapter-name").set(operation.get("default-resource-adapter-name"));
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        String poolName;
        final boolean lite = model.hasDefined("lite") && model.get("lite").asBoolean();
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor(Phase.PARSE, 4352, (DeploymentUnitProcessor)new EjbJarParsingDeploymentUnitProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 4432, (DeploymentUnitProcessor)new SessionBeanComponentDescriptionFactory());
                if (!lite) {
                    logger.debug((Object)"Add support for MDB");
                    processorTarget.addDeploymentProcessor(Phase.PARSE, 4433, (DeploymentUnitProcessor)new MessageDrivenComponentDescriptionFactory());
                    processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 1550, (DeploymentUnitProcessor)new AsynchronousMergingProcessor());
                }
                processorTarget.addDeploymentProcessor(Phase.PARSE, 3344, (DeploymentUnitProcessor)new EjbAnnotationProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 4608, (DeploymentUnitProcessor)new SessionBeanXmlDescriptorProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 11776, (DeploymentUnitProcessor)new EjbContextJndiBindingProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 11777, (DeploymentUnitProcessor)new TimerServiceJndiBindingProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 14080, (DeploymentUnitProcessor)new EjbResourceInjectionAnnotationProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 6401, (DeploymentUnitProcessor)new ApplicationExceptionAnnotationProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 13568, (DeploymentUnitProcessor)new InterceptorClassDeploymentDescriptorProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 13824, (DeploymentUnitProcessor)new AssemblyDescriptorProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 13569, (DeploymentUnitProcessor)new SecurityRoleRefDDProcessor());
                processorTarget.addDeploymentProcessor(Phase.DEPENDENCIES, 0, (DeploymentUnitProcessor)new EjbDependencyDeploymentUnitProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 1024, (DeploymentUnitProcessor)new BusinessViewAnnotationProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 4096, (DeploymentUnitProcessor)new ImplicitLocalViewProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 4352, (DeploymentUnitProcessor)new EjbJndiBindingsDeploymentUnitProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 4608, (DeploymentUnitProcessor)new EjbJarConfigurationProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 1536, (DeploymentUnitProcessor)new DeploymentDescriptorInterceptorBindingsProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 1025, (DeploymentUnitProcessor)new DeploymentDescriptorMethodProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 5376, (DeploymentUnitProcessor)new EjbRefProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 1538, (DeploymentUnitProcessor)new TransactionManagementMergingProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 1540, (DeploymentUnitProcessor)new ConcurrencyManagementMergingProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 1541, (DeploymentUnitProcessor)new EjbConcurrencyMergingProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 1539, (DeploymentUnitProcessor)new TransactionAttributeMergingProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 1542, (DeploymentUnitProcessor)new RunAsMergingProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 1543, (DeploymentUnitProcessor)new ResourceAdaptorMergingProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 1544, (DeploymentUnitProcessor)new RemoveMethodMergingProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 1545, (DeploymentUnitProcessor)new StartupMergingProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 1546, (DeploymentUnitProcessor)new SecurityDomainMergingProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 1547, (DeploymentUnitProcessor)new DeclareRolesMergingProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 1548, (DeploymentUnitProcessor)new MethodPermissionsMergingProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 1549, (DeploymentUnitProcessor)new StatefulTimeoutMergingProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 1551, (DeploymentUnitProcessor)new SessionSynchronizationMergingProcessor());
                processorTarget.addDeploymentProcessor(Phase.INSTALL, 1026, (DeploymentUnitProcessor)new EjbInjectionResolutionProcessor());
                processorTarget.addDeploymentProcessor(Phase.INSTALL, 4624, (DeploymentUnitProcessor)new EjbDependsOnMergingProcessor());
                processorTarget.addDeploymentProcessor(Phase.CLEANUP, 768, (DeploymentUnitProcessor)new EjbCleanUpProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
        if (model.hasDefined("default-mdb-instance-pool")) {
            poolName = model.get("default-mdb-instance-pool").asString();
            context.addStep((OperationStepHandler)new SetDefaultMDBPool.DefaultMDBPoolConfigServiceUpdateHandler(poolName), OperationContext.Stage.RUNTIME);
        }
        if (model.hasDefined("default-slsb-instance-pool")) {
            poolName = model.get("default-slsb-instance-pool").asString();
            context.addStep((OperationStepHandler)new SetDefaultSLSBPool.DefaultSLSBPoolConfigServiceUpdateHandler(poolName), OperationContext.Stage.RUNTIME);
        }
        if (model.hasDefined("default-resource-adapter-name")) {
            String raName = model.get("default-resource-adapter-name").asString();
            context.addStep((OperationStepHandler)new SetDefaultResourceAdapterName.DefaultResourceAdapterNameUpdateHandler(raName), OperationContext.Stage.RUNTIME);
        }
        ServiceTarget serviceTarget = context.getServiceTarget();
        EJBUtilities utilities = new EJBUtilities();
        newControllers.add(serviceTarget.addService(EJBUtilities.SERVICE_NAME, (Service)utilities).addDependency(ConnectorServices.RA_REPOSISTORY_SERVICE, ResourceAdapterRepository.class, utilities.getResourceAdapterRepositoryInjector()).addDependency(ConnectorServices.IRONJACAMAR_MDR, MetadataRepository.class, utilities.getMdrInjector()).addDependency(SimpleSecurityManagerService.SERVICE_NAME, SimpleSecurityManager.class, utilities.getSecurityManagerInjector()).addDependency(TxnServices.JBOSS_TXN_TRANSACTION_MANAGER, TransactionManager.class, utilities.getTransactionManagerInjector()).addDependency(TxnServices.JBOSS_TXN_SYNCHRONIZATION_REGISTRY, TransactionSynchronizationRegistry.class, utilities.getTransactionSynchronizationRegistryInjector()).addDependency(TxnServices.JBOSS_TXN_USER_TRANSACTION, UserTransaction.class, utilities.getUserTransactionInjector()).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install());
        if (!lite) {
            UnboundedQueueThreadPoolService threadPoolService = new UnboundedQueueThreadPoolService(Runtime.getRuntime().availableProcessors(), TimeSpec.DEFAULT_KEEPALIVE);
            threadPoolService.getThreadFactoryInjector().inject((Object)Executors.defaultThreadFactory());
            newControllers.add(serviceTarget.addService(SessionBeanComponent.ASYNC_EXECUTOR_SERVICE_NAME, (Service)threadPoolService).addListener((ServiceListener)verificationHandler).install());
        }
    }
}

