/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.ejb.Asynchronous;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ee.metadata.ClassAnnotationInformation;
import org.jboss.as.ee.metadata.MethodAnnotationAggregator;
import org.jboss.as.ee.metadata.RuntimeAnnotationInformation;
import org.jboss.as.ejb3.component.AsyncFutureInterceptorFactory;
import org.jboss.as.ejb3.component.AsyncVoidInterceptorFactory;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.session.SessionBeanComponent;
import org.jboss.as.ejb3.component.session.SessionBeanComponentCreateService;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.deployment.processors.dd.MethodResolutionUtils;
import org.jboss.as.ejb3.deployment.processors.merging.AbstractMergingProcessor;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndexUtil;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.metadata.ejb.spec.AsyncMethodMetaData;
import org.jboss.metadata.ejb.spec.AsyncMethodsMetaData;
import org.jboss.metadata.ejb.spec.SessionBean31MetaData;
import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
import org.jboss.msc.service.ServiceBuilder;

public class AsynchronousMergingProcessor
extends AbstractMergingProcessor<SessionBeanComponentDescription> {
    public AsynchronousMergingProcessor() {
        super(SessionBeanComponentDescription.class);
    }

    @Override
    protected void handleAnnotations(DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, SessionBeanComponentDescription description) throws DeploymentUnitProcessingException {
        RuntimeAnnotationInformation data = MethodAnnotationAggregator.runtimeAnnotationInformation(componentClass, (EEApplicationClasses)applicationClasses, (DeploymentReflectionIndex)deploymentReflectionIndex, Asynchronous.class);
        for (Map.Entry entry : data.getClassAnnotations().entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            description.addAsynchronousClass((String)entry.getKey());
        }
        for (Map.Entry entry : data.getMethodAnnotations().entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            description.addAsynchronousMethod(MethodIdentifier.getIdentifierForMethod((Method)((Method)entry.getKey())));
        }
        for (ViewDescription view : description.getViews()) {
            ClassAnnotationInformation annotations;
            EEModuleClassDescription viewClass = applicationClasses.getClassByName(view.getViewClassName());
            if (viewClass == null || (annotations = viewClass.getAnnotationInformation(Asynchronous.class)) == null || annotations.getClassLevelAnnotations().isEmpty()) continue;
            description.addAsynchronousView(view.getViewClassName());
        }
    }

    @Override
    protected void handleDeploymentDescriptor(DeploymentUnit deploymentUnit, final DeploymentReflectionIndex deploymentReflectionIndex, final Class<?> componentClass, SessionBeanComponentDescription description) throws DeploymentUnitProcessingException {
        SessionBean31MetaData sessionBeanData;
        AsyncMethodsMetaData asyn;
        SessionBeanMetaData data = description.getDescriptorData();
        if (data != null && data instanceof SessionBean31MetaData && (asyn = (sessionBeanData = (SessionBean31MetaData)data).getAsyncMethods()) != null) {
            for (AsyncMethodMetaData method : asyn) {
                Method m = MethodResolutionUtils.resolveMethod(method.getMethodName(), method.getMethodParams(), componentClass, deploymentReflectionIndex);
                description.addAsynchronousMethod(MethodIdentifier.getIdentifierForMethod((Method)m));
            }
        }
        if (!(description.getAsynchronousClasses().isEmpty() && description.getAsynchronousMethods().isEmpty() && description.getAsynchronousViews().isEmpty())) {
            description.getConfigurators().add(new ComponentConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                    configuration.getCreateDependencies().add(new DependencyConfigurator<SessionBeanComponentCreateService>(){

                        public void configureDependency(ServiceBuilder<?> serviceBuilder, SessionBeanComponentCreateService service) throws DeploymentUnitProcessingException {
                            serviceBuilder.addDependency(SessionBeanComponent.ASYNC_EXECUTOR_SERVICE_NAME, ExecutorService.class, service.getAsyncExecutorService());
                        }
                    });
                }
            });
            for (final ViewDescription view : description.getViews()) {
                EJBViewDescription ejbView = (EJBViewDescription)view;
                ejbView.getConfigurators().add(new ViewConfigurator(){

                    public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                        SessionBeanComponentDescription componentDescription = (SessionBeanComponentDescription)componentConfiguration.getComponentDescription();
                        boolean asyncView = componentDescription.getAsynchronousViews().contains(view.getViewClassName());
                        for (Method method : configuration.getProxyFactory().getCachedMethods()) {
                            boolean methodFromAsyncView;
                            Method componentMethod = ClassReflectionIndexUtil.findRequiredMethod((DeploymentReflectionIndex)deploymentReflectionIndex, (ClassReflectionIndex)deploymentReflectionIndex.getClassIndex(componentClass), (Method)method);
                            if (componentMethod == null) continue;
                            boolean bl = methodFromAsyncView = asyncView && method.getDeclaringClass() != Object.class;
                            if (methodFromAsyncView || componentDescription.getAsynchronousClasses().contains(componentMethod.getDeclaringClass().getName())) {
                                AsynchronousMergingProcessor.addAsyncInterceptor(configuration, method);
                                continue;
                            }
                            MethodIdentifier id = MethodIdentifier.getIdentifierForMethod((Method)method);
                            if (!componentDescription.getAsynchronousMethods().contains(id)) continue;
                            AsynchronousMergingProcessor.addAsyncInterceptor(configuration, method);
                        }
                    }
                });
            }
        }
    }

    private static void addAsyncInterceptor(ViewConfiguration configuration, Method method) throws DeploymentUnitProcessingException {
        if (method.getReturnType().equals(Void.TYPE)) {
            configuration.addClientInterceptor(method, AsyncVoidInterceptorFactory.INSTANCE, 512);
        } else if (method.getReturnType().equals(Future.class)) {
            configuration.addClientInterceptor(method, AsyncFutureInterceptorFactory.INSTANCE, 512);
        } else {
            throw new DeploymentUnitProcessingException("Async method " + method + " does not return void or Future");
        }
    }
}

