/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.pool;

import java.util.concurrent.TimeUnit;
import org.jboss.as.ejb3.component.pool.PoolConfig;
import org.jboss.as.ejb3.pool.Pool;
import org.jboss.as.ejb3.pool.StatelessObjectFactory;
import org.jboss.as.ejb3.pool.strictmax.StrictMaxPool;

public class StrictMaxPoolConfig
extends PoolConfig {
    public static final int DEFAULT_MAX_POOL_SIZE = 20;
    public static final long DEFAULT_TIMEOUT = 5L;
    public static final TimeUnit DEFAULT_TIMEOUT_UNIT = TimeUnit.MINUTES;
    private final int maxPoolSize;
    private final TimeUnit timeoutUnit;
    private final long timeout;

    public StrictMaxPoolConfig(String poolName, int maxSize, long timeout, TimeUnit timeUnit) {
        super(poolName);
        this.maxPoolSize = maxSize;
        this.timeout = timeout;
        this.timeoutUnit = timeUnit;
    }

    @Override
    public Pool<?> createPool(StatelessObjectFactory statelessObjectFactory) {
        return new StrictMaxPool(statelessObjectFactory, this.maxPoolSize, this.timeout, this.timeoutUnit);
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public String toString() {
        return "StrictMaxPoolConfig{name=" + this.poolName + "maxPoolSize=" + this.maxPoolSize + ", timeoutUnit=" + (Object)((Object)this.timeoutUnit) + ", timeout=" + this.timeout + '}';
    }
}

