/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.messagedriven;

import java.util.Properties;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentCreateServiceFactory;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.EEApplicationDescription;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.messagedriven.DefaultResourceAdapterService;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentCreateService;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentCreateServiceFactory;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentInstanceAssociatingFactory;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenInvocationContextInterceptor;
import org.jboss.as.ejb3.component.pool.PoolConfig;
import org.jboss.as.ejb3.component.pool.PoolConfigService;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.metadata.ejb.spec.MessageDrivenBeanMetaData;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public class MessageDrivenComponentDescription
extends EJBComponentDescription {
    private final Properties activationProps;
    private String resourceAdapterName;
    private String mdbPoolConfigName;

    public MessageDrivenComponentDescription(String componentName, String componentClassName, EjbJarDescription ejbJarDescription, ServiceName deploymentUnitServiceName, String messageListenerInterfaceName, Properties activationProps) {
        super(componentName, componentClassName, ejbJarDescription, deploymentUnitServiceName);
        if (messageListenerInterfaceName == null || messageListenerInterfaceName.isEmpty()) {
            throw new IllegalArgumentException("Cannot set null or empty string as message listener interface");
        }
        this.activationProps = activationProps;
        this.registerView(messageListenerInterfaceName, MethodIntf.MESSAGE_ENDPOINT);
    }

    public ComponentConfiguration createConfiguration(EEApplicationDescription applicationDescription) {
        ComponentConfiguration mdbComponentConfiguration = new ComponentConfiguration((ComponentDescription)this, applicationDescription.getClassConfiguration(this.getComponentClassName()));
        mdbComponentConfiguration.setComponentCreateServiceFactory((ComponentCreateServiceFactory)new MessageDrivenComponentCreateServiceFactory());
        MessageDrivenComponentDescription mdbComponentDescription = (MessageDrivenComponentDescription)mdbComponentConfiguration.getComponentDescription();
        mdbComponentConfiguration.getCreateDependencies().add(new PoolInjectingConfigurator(mdbComponentDescription));
        mdbComponentConfiguration.getCreateDependencies().add(new DefaultRANameInjectingConfigurator(mdbComponentDescription));
        return mdbComponentConfiguration;
    }

    public Properties getActivationProps() {
        return this.activationProps;
    }

    public String getResourceAdapterName() {
        return this.resourceAdapterName;
    }

    public void setResourceAdapterName(String resourceAdapterName) {
        if (resourceAdapterName == null || resourceAdapterName.trim().isEmpty()) {
            throw new IllegalArgumentException("Resource adapter name cannot be null or empty");
        }
        this.resourceAdapterName = resourceAdapterName;
    }

    @Override
    protected void setupViewInterceptors(ViewDescription view) {
        super.setupViewInterceptors(view);
        view.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                configuration.addViewInterceptor((InterceptorFactory)MessageDrivenComponentInstanceAssociatingFactory.instance(), 1280);
            }
        });
    }

    @Override
    protected void addCurrentInvocationContextFactory() {
        this.getConfigurators().add(new ComponentConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                configuration.addPostConstructInterceptor(MessageDrivenInvocationContextInterceptor.FACTORY, 512);
                configuration.addPreDestroyInterceptor(MessageDrivenInvocationContextInterceptor.FACTORY, 512);
            }
        });
    }

    @Override
    protected void addCurrentInvocationContextFactory(ViewDescription view) {
        view.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                configuration.addViewInterceptor(MessageDrivenInvocationContextInterceptor.FACTORY, 768);
            }
        });
    }

    @Override
    public boolean isMessageDriven() {
        return true;
    }

    public void setPoolConfigName(String mdbPoolConfigName) {
        this.mdbPoolConfigName = mdbPoolConfigName;
    }

    public String getPoolConfigName() {
        return this.mdbPoolConfigName;
    }

    public boolean isTimerServiceApplicable() {
        return true;
    }

    public MessageDrivenBeanMetaData getDescriptorData() {
        return (MessageDrivenBeanMetaData)super.getDescriptorData();
    }

    private class DefaultRANameInjectingConfigurator
    implements DependencyConfigurator<Service<Component>> {
        private final MessageDrivenComponentDescription mdbComponentDescription;

        DefaultRANameInjectingConfigurator(MessageDrivenComponentDescription mdbComponentDescription) {
            this.mdbComponentDescription = mdbComponentDescription;
        }

        public void configureDependency(ServiceBuilder<?> serviceBuilder, Service<Component> service) throws DeploymentUnitProcessingException {
            MessageDrivenComponentCreateService mdbComponentCreateService = (MessageDrivenComponentCreateService)service;
            serviceBuilder.addDependency(ServiceBuilder.DependencyType.OPTIONAL, DefaultResourceAdapterService.DEFAULT_RA_NAME_SERVICE_NAME, DefaultResourceAdapterService.class, mdbComponentCreateService.getDefaultRANameServiceInjector());
        }
    }

    private class PoolInjectingConfigurator
    implements DependencyConfigurator<Service<Component>> {
        private final MessageDrivenComponentDescription mdbComponentDescription;

        PoolInjectingConfigurator(MessageDrivenComponentDescription mdbComponentDescription) {
            this.mdbComponentDescription = mdbComponentDescription;
        }

        public void configureDependency(ServiceBuilder<?> serviceBuilder, Service<Component> service) throws DeploymentUnitProcessingException {
            MessageDrivenComponentCreateService mdbComponentCreateService = (MessageDrivenComponentCreateService)service;
            String poolName = this.mdbComponentDescription.getPoolConfigName();
            if (poolName == null) {
                serviceBuilder.addDependency(ServiceBuilder.DependencyType.OPTIONAL, PoolConfigService.DEFAULT_MDB_POOL_CONFIG_SERVICE_NAME, PoolConfig.class, mdbComponentCreateService.getPoolConfigInjector());
            } else {
                serviceBuilder.addDependency(PoolConfigService.EJB_POOL_CONFIG_BASE_SERVICE_NAME.append(new String[]{poolName}), PoolConfig.class, mdbComponentCreateService.getPoolConfigInjector());
            }
        }
    }
}

