/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import org.jboss.as.ee.component.Component;
import org.jboss.as.ejb3.component.session.SessionBeanComponent;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.logging.Logger;

public final class AsyncVoidInterceptorFactory
implements InterceptorFactory {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.ejb3.component.async");
    public static final InterceptorFactory INSTANCE = new AsyncVoidInterceptorFactory();

    public Interceptor create(InterceptorFactoryContext context) {
        final SessionBeanComponent component = (SessionBeanComponent)context.getContextData().get(Component.class);
        return new Interceptor(){

            public Object processInvocation(InterceptorContext context) throws Exception {
                component.getAsynchronousExecutor().execute(new Task(context.clone()));
                return null;
            }
        };
    }

    private static class Task
    implements Runnable {
        private final InterceptorContext context;

        private Task(InterceptorContext context) {
            this.context = context;
        }

        @Override
        public void run() {
            try {
                this.context.proceed();
            }
            catch (Exception e) {
                log.error((Object)"Asynchronous invocation failed", (Throwable)e);
            }
        }
    }
}

