/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.security.AuthorizationInterceptor;
import org.jboss.as.ejb3.security.EJBMethodSecurityMetaData;
import org.jboss.as.ejb3.security.SecurityContextInterceptorFactory;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.logging.Logger;

public class EJBSecurityViewConfigurator
implements ViewConfigurator {
    private static final Logger logger = Logger.getLogger(EJBSecurityViewConfigurator.class);

    public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription viewDescription, ViewConfiguration viewConfiguration) throws DeploymentUnitProcessingException {
        Method[] viewMethods;
        if (!(componentConfiguration.getComponentDescription() instanceof EJBComponentDescription)) {
            throw new IllegalArgumentException("Component named " + componentConfiguration.getComponentName() + " with component class " + componentConfiguration.getComponentClass() + " is not a EJB component");
        }
        EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)componentConfiguration.getComponentDescription();
        if (!ejbComponentDescription.isSecurityEnabled()) {
            logger.debug((Object)("Security is *not* enabled on EJB: " + ejbComponentDescription.getEJBName() + ", no security interceptors will apply"));
            return;
        }
        String viewClassName = viewDescription.getViewClassName();
        viewConfiguration.addViewInterceptor((InterceptorFactory)new SecurityContextInterceptorFactory(), 336);
        for (Method viewMethod : viewMethods = viewConfiguration.getProxyFactory().getCachedMethods()) {
            if (!Modifier.isPublic(viewMethod.getModifiers())) continue;
            EJBMethodSecurityMetaData ejbMethodSecurityMetaData = new EJBMethodSecurityMetaData(componentConfiguration, viewClassName, viewMethod);
            AuthorizationInterceptor authorizationInterceptor = new AuthorizationInterceptor(ejbMethodSecurityMetaData, viewClassName, viewMethod);
            viewConfiguration.addViewInterceptor(viewMethod, (InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)authorizationInterceptor), 512);
        }
    }
}

