/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.ee.component.AbstractDeploymentDescriptorBindingsProcessor;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.LookupInjectionSource;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.processors.EjbInjectionSource;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.metadata.javaee.spec.EJBLocalReferenceMetaData;
import org.jboss.metadata.javaee.spec.EJBLocalReferencesMetaData;
import org.jboss.metadata.javaee.support.ResourceInjectionMetaDataWithDescriptions;
import org.jboss.msc.service.ServiceName;

public class EjbRefProcessor
extends AbstractDeploymentDescriptorBindingsProcessor {
    protected List<BindingConfiguration> processDescriptorEntries(DeploymentUnit deploymentUnit, DeploymentDescriptorEnvironment environment, EEModuleDescription moduleDescription, ComponentDescription componentDescription, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex) throws DeploymentUnitProcessingException {
        EJBLocalReferencesMetaData ejbLocalRefs = environment.getEnvironment().getEjbLocalReferences();
        ArrayList<BindingConfiguration> bindingDescriptions = new ArrayList<BindingConfiguration>();
        if (ejbLocalRefs != null) {
            for (EJBLocalReferenceMetaData ejbRef : ejbLocalRefs) {
                BindingConfiguration bindingConfiguration;
                LookupInjectionSource injectionSource;
                String name = ejbRef.getEjbRefName();
                String ejbName = ejbRef.getLink();
                String lookup = ejbRef.getLookupName();
                String localInterface = ejbRef.getLocal();
                Class localInterfaceType = null;
                if (!this.isEmpty(localInterface)) {
                    try {
                        classLoader.loadClass(localInterface);
                    }
                    catch (ClassNotFoundException e) {
                        throw new DeploymentUnitProcessingException("Could not load local interface type " + localInterface, (Throwable)e);
                    }
                }
                if (!name.startsWith("java:")) {
                    name = environment.getDefaultContext() + name;
                }
                if ((localInterfaceType = this.processInjectionTargets(moduleDescription, (InjectionSource)(injectionSource = new LookupInjectionSource(name)), classLoader, deploymentReflectionIndex, (ResourceInjectionMetaDataWithDescriptions)ejbRef, localInterfaceType)) == null) {
                    throw new DeploymentUnitProcessingException("Could not determine type of ejb-local-ref " + name + " for component " + componentDescription);
                }
                EjbInjectionSource ejbInjectionSource = null;
                if (!this.isEmpty(lookup)) {
                    bindingConfiguration = new BindingConfiguration(name, (InjectionSource)new LookupInjectionSource(lookup));
                } else if (!this.isEmpty(ejbName)) {
                    ServiceName beanServiceName = deploymentUnit.getServiceName().append(new String[]{"component"}).append(new String[]{ejbName}).append(new String[]{"VIEW"}).append(new String[]{localInterfaceType.getName()}).append(new String[]{MethodIntf.LOCAL.toString()});
                    ejbInjectionSource = new EjbInjectionSource(ejbName, localInterfaceType.getName());
                    bindingConfiguration = new BindingConfiguration(name, (InjectionSource)ejbInjectionSource);
                } else {
                    ejbInjectionSource = new EjbInjectionSource(localInterfaceType.getName());
                    bindingConfiguration = new BindingConfiguration(name, (InjectionSource)ejbInjectionSource);
                }
                if (ejbInjectionSource != null) {
                    deploymentUnit.addToAttachmentList(EjbDeploymentAttachmentKeys.EJB_INJECTIONS, (Object)ejbInjectionSource);
                }
                bindingDescriptions.add(bindingConfiguration);
            }
        }
        return bindingDescriptions;
    }

    private boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }
}

