/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.session;

import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Map;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ee.component.ComponentViewInstance;
import org.jboss.as.ejb3.component.CancellationFlag;
import org.jboss.as.ejb3.component.session.SessionBeanComponent;
import org.jboss.as.ejb3.component.session.SessionBeanComponentInstance;
import org.jboss.ejb3.context.CurrentInvocationContext;
import org.jboss.ejb3.context.base.BaseSessionInvocationContext;
import org.jboss.ejb3.context.spi.InvocationContext;
import org.jboss.ejb3.context.spi.SessionContext;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;

public class SessionInvocationContextInterceptor
implements Interceptor {
    public static final InterceptorFactory FACTORY = new ImmediateInterceptorFactory((Interceptor)new SessionInvocationContextInterceptor(false));
    public static final InterceptorFactory LIFECYCLE_FACTORY = new ImmediateInterceptorFactory((Interceptor)new SessionInvocationContextInterceptor(true));
    private final boolean lifecycleCallback;

    private SessionInvocationContextInterceptor(boolean lifecycleCallback) {
        this.lifecycleCallback = lifecycleCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        Method invokedMethod = context.getMethod();
        ComponentViewInstance componentViewInstance = (ComponentViewInstance)context.getPrivateData(ComponentViewInstance.class);
        Class invokedBusinessInterface = componentViewInstance == null ? null : componentViewInstance.getViewClass();
        Object[] parameters = context.getParameters();
        CustomSessionInvocationContext sessionInvocationContext = new CustomSessionInvocationContext(this.lifecycleCallback, context, invokedBusinessInterface, invokedMethod, parameters);
        context.putPrivateData(InvocationContext.class, (Object)sessionInvocationContext);
        CurrentInvocationContext.push((InvocationContext)sessionInvocationContext);
        try {
            Object object = context.proceed();
            return object;
        }
        finally {
            CurrentInvocationContext.pop();
            context.putPrivateData(InvocationContext.class, null);
        }
    }

    protected static class CustomSessionInvocationContext
    extends BaseSessionInvocationContext {
        private InterceptorContext context;

        protected CustomSessionInvocationContext(boolean lifecycleCallback, InterceptorContext context, Class<?> invokedBusinessInterface, Method method, Object[] parameters) {
            super(lifecycleCallback, invokedBusinessInterface, method, parameters);
            this.context = context;
        }

        public Principal getCallerPrincipal() {
            return ((SessionBeanComponent)this.getComponent()).getCallerPrincipal();
        }

        public Map<String, Object> getContextData() {
            return this.context.getContextData();
        }

        public SessionContext getEJBContext() {
            return ((SessionBeanComponentInstance)((Object)this.context.getPrivateData(ComponentInstance.class))).getSessionContext();
        }

        public Object proceed() throws Exception {
            return this.context.proceed();
        }

        public void setParameters(Object[] params) throws IllegalArgumentException, IllegalStateException {
            this.context.setParameters(params);
        }

        public boolean wasCancelCalled() throws IllegalStateException {
            CancellationFlag flag = (CancellationFlag)this.context.getPrivateData(CancellationFlag.class);
            if (flag != null) {
                return flag.get();
            }
            return super.wasCancelCalled();
        }
    }
}

