/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.session;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.AccessTimeout;
import javax.ejb.LockType;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ejb3.PrimitiveClassLoaderUtil;
import org.jboss.as.ejb3.component.EJBBusinessMethod;
import org.jboss.as.ejb3.component.EJBComponentCreateService;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.deployment.EjbJarConfiguration;
import org.jboss.invocation.proxy.MethodIdentifier;

public abstract class SessionBeanComponentCreateService
extends EJBComponentCreateService {
    private final Map<String, LockType> beanLevelLockType;
    private final Map<EJBBusinessMethod, LockType> methodApplicableLockTypes;
    private final Map<String, AccessTimeout> beanLevelAccessTimeout;
    private final Map<EJBBusinessMethod, AccessTimeout> methodApplicableAccessTimeouts;

    public SessionBeanComponentCreateService(ComponentConfiguration componentConfiguration, EjbJarConfiguration ejbJarConfiguration) {
        super(componentConfiguration, ejbJarConfiguration);
        SessionBeanComponentDescription sessionBeanComponentDescription = (SessionBeanComponentDescription)componentConfiguration.getComponentDescription();
        this.beanLevelLockType = sessionBeanComponentDescription.getBeanLevelLockType();
        Map<MethodIdentifier, LockType> methodLocks = sessionBeanComponentDescription.getMethodApplicableLockTypes();
        if (methodLocks == null) {
            this.methodApplicableLockTypes = Collections.emptyMap();
        } else {
            HashMap<EJBBusinessMethod, LockType> locks = new HashMap<EJBBusinessMethod, LockType>();
            for (Map.Entry<MethodIdentifier, LockType> entry : methodLocks.entrySet()) {
                MethodIdentifier ejbMethodDescription = entry.getKey();
                EJBBusinessMethod ejbMethod = this.getEJBBusinessMethod(ejbMethodDescription);
                locks.put(ejbMethod, entry.getValue());
            }
            this.methodApplicableLockTypes = Collections.unmodifiableMap(locks);
        }
        this.beanLevelAccessTimeout = sessionBeanComponentDescription.getBeanLevelAccessTimeout();
        Map<MethodIdentifier, AccessTimeout> methodAccessTimeouts = sessionBeanComponentDescription.getMethodApplicableAccessTimeouts();
        if (methodAccessTimeouts == null) {
            this.methodApplicableAccessTimeouts = Collections.emptyMap();
        } else {
            HashMap<EJBBusinessMethod, AccessTimeout> accessTimeouts = new HashMap<EJBBusinessMethod, AccessTimeout>();
            for (Map.Entry<MethodIdentifier, AccessTimeout> entry : methodAccessTimeouts.entrySet()) {
                MethodIdentifier ejbMethodDescription = entry.getKey();
                EJBBusinessMethod ejbMethod = this.getEJBBusinessMethod(ejbMethodDescription);
                accessTimeouts.put(ejbMethod, entry.getValue());
            }
            this.methodApplicableAccessTimeouts = Collections.unmodifiableMap(accessTimeouts);
        }
    }

    public Map<String, LockType> getBeanLockType() {
        return this.beanLevelLockType;
    }

    public Map<EJBBusinessMethod, LockType> getMethodApplicableLockTypes() {
        return this.methodApplicableLockTypes;
    }

    public Map<EJBBusinessMethod, AccessTimeout> getMethodApplicableAccessTimeouts() {
        return this.methodApplicableAccessTimeouts;
    }

    public Map<String, AccessTimeout> getBeanAccessTimeout() {
        return this.beanLevelAccessTimeout;
    }

    private EJBBusinessMethod getEJBBusinessMethod(MethodIdentifier method) {
        ClassLoader classLoader = this.getComponentClass().getClassLoader();
        String methodName = method.getName();
        String[] types = method.getParameterTypes();
        if (types == null || types.length == 0) {
            return new EJBBusinessMethod(methodName, new Class[0]);
        }
        Class[] paramTypes = new Class[types.length];
        int i = 0;
        for (String type : types) {
            try {
                paramTypes[i++] = PrimitiveClassLoaderUtil.loadClass(type, classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return new EJBBusinessMethod(methodName, paramTypes);
    }
}

