/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.dd;

import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.metadata.ejb.spec.ApplicationExceptionMetaData;
import org.jboss.metadata.ejb.spec.ApplicationExceptionsMetaData;
import org.jboss.metadata.ejb.spec.AssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;

public class AssemblyDescriptorProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EjbJarMetaData ejbJarMetaData = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        if (ejbJarMetaData == null) {
            return;
        }
        AssemblyDescriptorMetaData assemblyDescriptor = ejbJarMetaData.getAssemblyDescriptor();
        if (assemblyDescriptor != null) {
            EjbJarDescription ejbJarDescription = (EjbJarDescription)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_DESCRIPTION);
            ApplicationExceptionsMetaData applicationExceptions = assemblyDescriptor.getApplicationExceptions();
            if (applicationExceptions != null && !applicationExceptions.isEmpty()) {
                for (ApplicationExceptionMetaData applicationException : applicationExceptions) {
                    String exceptionClassName = applicationException.getExceptionClass();
                    boolean rollback = applicationException.isRollback();
                    boolean inherited = applicationException.isInherited() == null ? true : applicationException.isInherited();
                    ejbJarDescription.addApplicationException(exceptionClassName, rollback, inherited);
                }
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

