/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.ApplicationException;
import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentDescription;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.deployment.EjbJarConfiguration;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;

public class EjbJarDescription {
    private EEModuleDescription eeModuleDescription;
    private Map<String, ApplicationException> applicationExceptions = new ConcurrentHashMap<String, ApplicationException>();

    public EjbJarDescription(EEModuleDescription eeModuleDescription) {
        if (eeModuleDescription == null) {
            throw new IllegalArgumentException(EEModuleDescription.class.getSimpleName() + " cannot be null");
        }
        this.eeModuleDescription = eeModuleDescription;
    }

    public void addApplicationException(String exceptionClassName, final boolean rollback, final boolean inherited) {
        if (exceptionClassName == null || exceptionClassName.isEmpty()) {
            throw new IllegalArgumentException("Invalid exception class name: " + exceptionClassName);
        }
        ApplicationException appException = new ApplicationException(){

            public boolean inherited() {
                return inherited;
            }

            public boolean rollback() {
                return rollback;
            }

            public Class<? extends Annotation> annotationType() {
                return ApplicationException.class;
            }
        };
        this.applicationExceptions.put(exceptionClassName, appException);
    }

    public EEModuleDescription getEEModuleDescription() {
        return this.eeModuleDescription;
    }

    Map<String, ApplicationException> getApplicationExceptions() {
        return Collections.unmodifiableMap(this.applicationExceptions);
    }

    public EjbJarConfiguration createEjbJarConfiguration(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        EjbJarConfiguration ejbDeploymentConfiguration = new EjbJarConfiguration(this);
        this.prepareEjbJarConfiguration(ejbDeploymentConfiguration, phaseContext);
        return ejbDeploymentConfiguration;
    }

    protected void prepareEjbJarConfiguration(EjbJarConfiguration ejbDeploymentConfiguration, DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        if (module == null) {
            throw new IllegalStateException("Module not yet set in deployment unit " + deploymentUnit);
        }
        ModuleClassLoader moduleClassLoader = module.getClassLoader();
        this.prepareApplicationExceptions(ejbDeploymentConfiguration, (ClassLoader)moduleClassLoader);
    }

    private void prepareApplicationExceptions(EjbJarConfiguration ejbDeploymentConfiguration, ClassLoader classLoader) throws DeploymentUnitProcessingException {
        for (Map.Entry<String, ApplicationException> entry : this.applicationExceptions.entrySet()) {
            String applicationExceptionClass = entry.getKey();
            try {
                Class<?> exceptionClass = classLoader.loadClass(applicationExceptionClass);
                ejbDeploymentConfiguration.addApplicationException(exceptionClass, entry.getValue());
            }
            catch (ClassNotFoundException cnfe) {
                throw new DeploymentUnitProcessingException((Throwable)cnfe);
            }
        }
    }

    public Collection<SessionBeanComponentDescription> getSessionBeans() {
        ArrayList<SessionBeanComponentDescription> sessionBeans = new ArrayList<SessionBeanComponentDescription>();
        for (AbstractComponentDescription componentDescription : this.eeModuleDescription.getComponentDescriptions()) {
            if (!(componentDescription instanceof SessionBeanComponentDescription)) continue;
            sessionBeans.add((SessionBeanComponentDescription)componentDescription);
        }
        return sessionBeans;
    }

    public Collection<MessageDrivenComponentDescription> getMessageDrivenBeans() {
        ArrayList<MessageDrivenComponentDescription> mdbs = new ArrayList<MessageDrivenComponentDescription>();
        for (AbstractComponentDescription componentDescription : this.eeModuleDescription.getComponentDescriptions()) {
            if (!(componentDescription instanceof MessageDrivenComponentDescription)) continue;
            mdbs.add((MessageDrivenComponentDescription)componentDescription);
        }
        return mdbs;
    }

    public void addSessionBeans(Collection<SessionBeanComponentDescription> sessionBeans) {
        for (SessionBeanComponentDescription sessionBean : sessionBeans) {
            this.eeModuleDescription.addComponent((AbstractComponentDescription)sessionBean);
        }
    }
}

