/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.session;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import javax.ejb.AccessTimeout;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.LockType;
import org.jboss.as.ee.component.AbstractComponentConfiguration;
import org.jboss.as.ejb3.PrimitiveClassLoaderUtil;
import org.jboss.as.ejb3.component.EJBBusinessMethod;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBMethodDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.session.SessionBeanComponent;
import org.jboss.as.ejb3.component.session.SessionBeanComponentConfiguration;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.msc.service.ServiceBuilder;

public abstract class SessionBeanComponentDescription
extends EJBComponentDescription {
    private boolean noInterfaceViewPresent;
    private Map<String, MethodIntf> viewTypes = new HashMap<String, MethodIntf>();
    private ConcurrencyManagementType concurrencyManagementType;
    private LockType beanLevelLockType;
    private AccessTimeout beanLevelAccessTimeout;
    private Map<EJBMethodDescription, LockType> methodLockTypes = new ConcurrentHashMap<EJBMethodDescription, LockType>();
    private Map<EJBMethodDescription, AccessTimeout> methodAccessTimeouts = new ConcurrentHashMap<EJBMethodDescription, AccessTimeout>();
    private final Set<MethodIdentifier> asynchronousMethods = new HashSet<MethodIdentifier>();
    private final Set<String> asynchronousViews = new HashSet<String>();
    private String mappedName;

    public SessionBeanComponentDescription(String componentName, String componentClassName, EjbJarDescription ejbModuleDescription) {
        super(componentName, componentClassName, ejbModuleDescription);
        this.addDependency(SessionBeanComponent.ASYNC_EXECUTOR_SERVICE_NAME, ServiceBuilder.DependencyType.REQUIRED);
    }

    public abstract boolean allowsConcurrentAccess();

    public void addLocalBusinessInterfaceViews(Collection<String> classNames) {
        this.getViewClassNames().addAll(classNames);
        for (String viewClassName : classNames) {
            if (this.viewTypes.get(viewClassName) == MethodIntf.REMOTE) {
                throw new IllegalStateException("[EJB 3.1 spec, section 4.9.7] - Can't add view class: " + viewClassName + " as local view since it's already marked as remote view for bean: " + this.getEJBName());
            }
            this.viewTypes.put(viewClassName, MethodIntf.LOCAL);
        }
    }

    public void addLocalBusinessInterfaceViews(String ... classNames) {
        this.addLocalBusinessInterfaceViews(Arrays.asList(classNames));
    }

    public void addNoInterfaceView() {
        this.noInterfaceViewPresent = true;
        this.getViewClassNames().add(this.getEJBClassName());
        this.viewTypes.put(this.getEJBClassName(), MethodIntf.LOCAL);
    }

    public void addRemoteBusinessInterfaceViews(Collection<String> classNames) {
        this.getViewClassNames().addAll(classNames);
        for (String viewClassName : classNames) {
            if (this.viewTypes.get(viewClassName) == MethodIntf.LOCAL) {
                throw new IllegalStateException("[EJB 3.1 spec, section 4.9.7] - Can't add view class: " + viewClassName + " as remote view since it's already marked as local view for bean: " + this.getEJBName());
            }
            this.viewTypes.put(viewClassName, MethodIntf.REMOTE);
        }
    }

    @Override
    public MethodIntf getMethodIntf(String viewClassName) {
        MethodIntf methodIntf = this.viewTypes.get(viewClassName);
        assert (methodIntf != null) : "no view type known for " + viewClassName;
        return methodIntf;
    }

    public boolean hasNoInterfaceView() {
        return this.noInterfaceViewPresent;
    }

    public void setBeanLevelLockType(LockType locktype) {
        if (this.beanLevelLockType != null && this.beanLevelLockType != locktype) {
            throw new IllegalArgumentException(this.getEJBName() + " bean has already been marked for " + this.beanLevelLockType + " lock type. Cannot change it to " + locktype);
        }
        this.beanLevelLockType = locktype;
    }

    public LockType getBeanLevelLockType() {
        return this.beanLevelLockType;
    }

    public void setLockType(LockType lockType, EJBMethodDescription method) {
        this.methodLockTypes.put(method, lockType);
    }

    public AccessTimeout getBeanLevelAccessTimeout() {
        return this.beanLevelAccessTimeout;
    }

    public void setBeanLevelAccessTimeout(AccessTimeout accessTimeout) {
        if (this.beanLevelAccessTimeout != null && this.beanLevelAccessTimeout != accessTimeout) {
            throw new IllegalArgumentException(this.getEJBName() + " bean has already been marked for " + this.beanLevelAccessTimeout + " access timeout. Cannot change it to " + accessTimeout);
        }
        this.beanLevelAccessTimeout = accessTimeout;
    }

    public void setAccessTimeout(AccessTimeout accessTimeout, EJBMethodDescription method) {
        this.methodAccessTimeouts.put(method, accessTimeout);
    }

    public ConcurrencyManagementType getConcurrencyManagementType() {
        return this.concurrencyManagementType;
    }

    public void beanManagedConcurrency() {
        if (this.concurrencyManagementType != null && this.concurrencyManagementType != ConcurrencyManagementType.BEAN) {
            throw new IllegalStateException(this.getEJBName() + " bean has been marked for " + this.concurrencyManagementType + " cannot change it now!");
        }
        this.concurrencyManagementType = ConcurrencyManagementType.BEAN;
    }

    public void containerManagedConcurrency() {
        if (this.concurrencyManagementType != null && this.concurrencyManagementType != ConcurrencyManagementType.CONTAINER) {
            throw new IllegalStateException(this.getEJBName() + " bean has been marked for " + this.concurrencyManagementType + " cannot change it now!");
        }
        this.concurrencyManagementType = ConcurrencyManagementType.CONTAINER;
    }

    public String getMappedName() {
        return this.mappedName;
    }

    public void setMappedName(String mappedName) {
        this.mappedName = mappedName;
    }

    public void addAsynchronousMethod(MethodIdentifier methodIdentifier) {
        this.asynchronousMethods.add(methodIdentifier);
    }

    public void addAsynchronousView(String viewName) {
        this.asynchronousViews.add(viewName);
    }

    public abstract SessionBeanType getSessionBeanType();

    @Override
    protected void processComponentMethod(AbstractComponentConfiguration configuration, Method componentMethod) throws DeploymentUnitProcessingException {
        super.processComponentMethod(configuration, componentMethod);
        if (this.asynchronousMethods.contains(MethodIdentifier.getIdentifierForMethod((Method)componentMethod)) || this.asynchronousViews.contains(componentMethod.getDeclaringClass().getName())) {
            if (!Void.TYPE.isAssignableFrom(componentMethod.getReturnType()) && !Future.class.isAssignableFrom(componentMethod.getReturnType())) {
                throw new DeploymentUnitProcessingException("Invalid asynchronous method [" + componentMethod + "].  Asynchronous methods must return either void or Future<V>.");
            }
            SessionBeanComponentConfiguration sessionBeanComponentConfiguration = (SessionBeanComponentConfiguration)configuration;
            sessionBeanComponentConfiguration.addAsynchronousMethod(componentMethod);
        }
    }

    @Override
    protected void prepareComponentConfiguration(AbstractComponentConfiguration configuration, DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        super.prepareComponentConfiguration(configuration, phaseContext);
        SessionBeanComponentConfiguration sessionBeanComponentConfiguration = (SessionBeanComponentConfiguration)configuration;
        this.prepareLockConfiguration(sessionBeanComponentConfiguration, phaseContext);
        this.prepareAccessTimeoutConfiguration(sessionBeanComponentConfiguration, phaseContext);
    }

    private void prepareAccessTimeoutConfiguration(SessionBeanComponentConfiguration sessionBeanComponentConfiguration, DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        ClassLoader beanClassLoader = sessionBeanComponentConfiguration.getComponentClass().getClassLoader();
        HashMap<EJBBusinessMethod, AccessTimeout> methodApplicableAccessTimeouts = new HashMap<EJBBusinessMethod, AccessTimeout>();
        for (Map.Entry<EJBMethodDescription, AccessTimeout> entry : this.methodAccessTimeouts.entrySet()) {
            EJBMethodDescription method = entry.getKey();
            try {
                EJBBusinessMethod ejbMethod = this.getEJBBusinessMethod(method, beanClassLoader);
                methodApplicableAccessTimeouts.put(ejbMethod, entry.getValue());
            }
            catch (ClassNotFoundException cnfe) {
                throw new DeploymentUnitProcessingException("Could not process @AccessTimeout configurations due to exception: ", (Throwable)cnfe);
            }
        }
        sessionBeanComponentConfiguration.setMethodApplicableAccessTimeout(methodApplicableAccessTimeouts);
    }

    private void prepareLockConfiguration(SessionBeanComponentConfiguration sessionBeanComponentConfiguration, DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        ClassLoader beanClassLoader = sessionBeanComponentConfiguration.getComponentClass().getClassLoader();
        HashMap<EJBBusinessMethod, LockType> methodApplicableLockTypes = new HashMap<EJBBusinessMethod, LockType>();
        for (Map.Entry<EJBMethodDescription, LockType> entry : this.methodLockTypes.entrySet()) {
            EJBMethodDescription method = entry.getKey();
            try {
                EJBBusinessMethod ejbMethod = this.getEJBBusinessMethod(method, beanClassLoader);
                methodApplicableLockTypes.put(ejbMethod, entry.getValue());
            }
            catch (ClassNotFoundException cnfe) {
                throw new DeploymentUnitProcessingException("Could not process LockType configurations due to exception: ", (Throwable)cnfe);
            }
        }
        sessionBeanComponentConfiguration.setMethodApplicableLockType(methodApplicableLockTypes);
    }

    private EJBBusinessMethod getEJBBusinessMethod(EJBMethodDescription method, ClassLoader classLoader) throws ClassNotFoundException {
        String methodName = method.getMethodName();
        String[] types = method.getMethodParams();
        if (types == null || types.length == 0) {
            return new EJBBusinessMethod(methodName, new Class[0]);
        }
        Class[] paramTypes = new Class[types.length];
        int i = 0;
        for (String type : types) {
            paramTypes[i++] = PrimitiveClassLoaderUtil.loadClass(type.toString(), classLoader);
        }
        return new EJBBusinessMethod(methodName, paramTypes);
    }

    public static enum SessionBeanType {
        STATELESS,
        STATEFUL,
        SINGLETON;

    }
}

