/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.ejb.ApplicationException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagementType;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import org.jboss.as.ee.component.AbstractComponent;
import org.jboss.as.ee.component.AbstractComponentConfiguration;
import org.jboss.as.ejb3.component.ArrayKey;
import org.jboss.as.ejb3.component.EJBComponentConfiguration;
import org.jboss.as.ejb3.component.EJBUtilities;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.ejb3.tx2.spi.TransactionalComponent;
import org.jboss.logging.Logger;

public abstract class EJBComponent
extends AbstractComponent
implements org.jboss.ejb3.context.spi.EJBComponent,
TransactionalComponent {
    private static Logger log = Logger.getLogger(EJBComponent.class);
    private final ConcurrentMap<MethodIntf, ConcurrentMap<String, ConcurrentMap<ArrayKey, TransactionAttributeType>>> txAttrs;
    private final EJBUtilities utilities;
    private final boolean isBeanManagedTransaction;
    private static volatile boolean youHaveBeenWarnedEJBTHREE2120 = false;
    private Map<Class<?>, ApplicationException> applicationExceptions;

    protected EJBComponent(EJBComponentConfiguration configuration) {
        super((AbstractComponentConfiguration)configuration);
        this.utilities = (EJBUtilities)configuration.getInjectionValue(EJBUtilities.SERVICE_NAME, EJBUtilities.class);
        this.applicationExceptions = configuration.getEjbJarConfiguration().getApplicationExceptions();
        this.txAttrs = configuration.getTxAttrs();
        this.isBeanManagedTransaction = configuration.getTransactionManagementType().equals((Object)TransactionManagementType.BEAN);
    }

    public ApplicationException getApplicationException(Class<?> exceptionClass) {
        ApplicationException applicationException = this.applicationExceptions.get(exceptionClass);
        if (applicationException != null) {
            return applicationException;
        }
        for (Class<?> superClass = exceptionClass.getSuperclass(); superClass != null && !superClass.equals(Exception.class) && !superClass.equals(Object.class); superClass = superClass.getSuperclass()) {
            applicationException = this.applicationExceptions.get(superClass);
            if (applicationException == null) continue;
            if (applicationException.inherited()) {
                return applicationException;
            }
            return null;
        }
        return null;
    }

    public EJBHome getEJBHome() throws IllegalStateException {
        throw new RuntimeException("NYI: org.jboss.as.ejb3.component.EJBComponent.getEJBHome");
    }

    public EJBLocalHome getEJBLocalHome() throws IllegalStateException {
        throw new RuntimeException("NYI: org.jboss.as.ejb3.component.EJBComponent.getEJBLocalHome");
    }

    public boolean getRollbackOnly() throws IllegalStateException {
        if (this.isBeanManagedTransaction()) {
            throw new IllegalStateException("EJB 3.1 FR 4.3.3 & 5.4.5 Only beans with container-managed transaction demarcation can use this method.");
        }
        throw new RuntimeException("NYI: org.jboss.as.ejb3.component.EJBComponent.getRollbackOnly");
    }

    public TimerService getTimerService() throws IllegalStateException {
        throw new RuntimeException("NYI: org.jboss.as.ejb3.component.EJBComponent.getTimerService");
    }

    @Deprecated
    public TransactionAttributeType getTransactionAttributeType(Method method) {
        if (!youHaveBeenWarnedEJBTHREE2120) {
            log.warn((Object)"EJBTHREE-2120: deprecated getTransactionAttributeType method called (dev problem)");
            youHaveBeenWarnedEJBTHREE2120 = true;
        }
        return this.getTransactionAttributeType(MethodIntf.BEAN, method);
    }

    public TransactionAttributeType getTransactionAttributeType(MethodIntf methodIntf, Method method) {
        ConcurrentMap perMethodIntf = (ConcurrentMap)this.txAttrs.get((Object)methodIntf);
        if (perMethodIntf == null) {
            throw new IllegalStateException("Can't find tx attrs for " + (Object)((Object)methodIntf));
        }
        ConcurrentMap perMethod = (ConcurrentMap)perMethodIntf.get(method.getName());
        if (perMethod == null) {
            throw new IllegalStateException("Can't find tx attrs for method name " + method.getName() + " via " + (Object)((Object)methodIntf));
        }
        TransactionAttributeType txAttr = (TransactionAttributeType)perMethod.get(new ArrayKey(method.getParameterTypes()));
        if (txAttr == null) {
            throw new IllegalStateException("Can't find tx attr for method " + method + " via " + (Object)((Object)methodIntf));
        }
        return txAttr;
    }

    public TransactionManager getTransactionManager() {
        return this.utilities.getTransactionManager();
    }

    public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return this.utilities.getTransactionSynchronizationRegistry();
    }

    public int getTransactionTimeout(Method method) {
        return -1;
    }

    public UserTransaction getUserTransaction() throws IllegalStateException {
        if (!this.isBeanManagedTransaction()) {
            throw new IllegalStateException("EJB 3.1 FR 4.3.3 & 5.4.5 Only beans with bean-managed transaction demarcation can use this method.");
        }
        return this.utilities.getUserTransaction();
    }

    private boolean isBeanManagedTransaction() {
        return this.isBeanManagedTransaction;
    }

    public boolean isCallerInRole(Principal callerPrincipal, String roleName) throws IllegalStateException {
        throw new RuntimeException("NYI: org.jboss.as.ejb3.component.EJBComponent.isCallerInRole");
    }

    public Object lookup(String name) throws IllegalArgumentException {
        throw new RuntimeException("NYI: org.jboss.as.ejb3.component.EJBComponent.lookup");
    }

    public void setRollbackOnly() throws IllegalStateException {
        if (this.isBeanManagedTransaction()) {
            throw new IllegalStateException("EJB 3.1 FR 4.3.3 & 5.4.5 Only beans with container-managed transaction demarcation can use this method.");
        }
        throw new RuntimeException("NYI: org.jboss.as.ejb3.component.EJBComponent.setRollbackOnly");
    }
}

