/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.singleton;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.ejb.AccessTimeout;
import javax.ejb.LockType;
import org.jboss.as.ee.component.AbstractComponentInstance;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ejb3.component.EJBBusinessMethod;
import org.jboss.as.ejb3.component.session.SessionBeanComponent;
import org.jboss.as.ejb3.component.singleton.SingletonComponentConfiguration;
import org.jboss.as.ejb3.component.singleton.SingletonComponentInstance;
import org.jboss.ejb3.concurrency.spi.LockableComponent;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.logging.Logger;

public class SingletonComponent
extends SessionBeanComponent
implements LockableComponent {
    private static final Logger logger = Logger.getLogger(SingletonComponent.class);
    private SingletonComponentInstance singletonComponentInstance;
    private boolean initOnStartup;
    private LockType beanLevelLockType;
    private Map<EJBBusinessMethod, LockType> methodLockTypes;
    private Map<EJBBusinessMethod, AccessTimeout> methodAccessTimeouts;

    public SingletonComponent(SingletonComponentConfiguration configuration) {
        super(configuration);
        this.initOnStartup = configuration.isInitOnStartup();
        this.beanLevelLockType = configuration.getBeanLevelLockType();
        this.methodLockTypes = configuration.getMethodApplicableLockTypes();
        this.methodAccessTimeouts = configuration.getMethodApplicableAccessTimeouts();
    }

    public synchronized ComponentInstance createInstance() {
        if (this.singletonComponentInstance != null) {
            throw new IllegalStateException("A singleton component instance has already been created for bean: " + this.getComponentName());
        }
        return super.createInstance();
    }

    protected synchronized AbstractComponentInstance constructComponentInstance(Object instance, List<Interceptor> preDestroyInterceptors, InterceptorFactoryContext context) {
        if (this.singletonComponentInstance != null) {
            throw new IllegalStateException("A singleton component instance has already been created for bean: " + this.getComponentName());
        }
        this.singletonComponentInstance = new SingletonComponentInstance(this, instance, preDestroyInterceptors, context);
        return this.singletonComponentInstance;
    }

    public Interceptor createClientInterceptor(Class<?> view) {
        return new Interceptor(){

            public Object processInvocation(InterceptorContext context) throws Exception {
                context.putPrivateData(Component.class, (Object)SingletonComponent.this);
                Method method = context.getMethod();
                if (SingletonComponent.this.isAsynchronous(method)) {
                    return SingletonComponent.this.invokeAsynchronous(method, context);
                }
                return context.proceed();
            }
        };
    }

    public Interceptor createClientInterceptor(Class<?> view, Serializable sessionId) {
        return this.createClientInterceptor(view);
    }

    synchronized ComponentInstance getComponentInstance() {
        if (this.singletonComponentInstance == null) {
            this.singletonComponentInstance = (SingletonComponentInstance)this.createInstance();
        }
        return this.singletonComponentInstance;
    }

    public void start() {
        super.start();
        if (this.initOnStartup) {
            logger.debug((Object)(this.getComponentName() + " bean is a @Startup (a.k.a init-on-startup) bean, creating/getting the singleton instance"));
            this.getComponentInstance();
        }
    }

    public void stop() {
        this.destroySingletonInstance();
        super.stop();
    }

    public LockType getLockType(Method method) {
        EJBBusinessMethod beanMethod = new EJBBusinessMethod(method.getName(), method.getParameterTypes());
        LockType lockType = this.methodLockTypes.get(beanMethod);
        if (lockType != null) {
            return lockType;
        }
        if (this.beanLevelLockType != null) {
            return this.beanLevelLockType;
        }
        return LockType.WRITE;
    }

    public AccessTimeout getAccessTimeout(Method method) {
        EJBBusinessMethod beanMethod = new EJBBusinessMethod(method.getName(), method.getParameterTypes());
        AccessTimeout accessTimeout = this.methodAccessTimeouts.get(beanMethod);
        if (accessTimeout != null) {
            return accessTimeout;
        }
        if (this.beanLevelAccessTimeout != null) {
            return this.beanLevelAccessTimeout;
        }
        return null;
    }

    public AccessTimeout getDefaultAccessTimeout() {
        return new AccessTimeout(){

            public long value() {
                return 5L;
            }

            public TimeUnit unit() {
                return TimeUnit.MINUTES;
            }

            public Class<? extends Annotation> annotationType() {
                return AccessTimeout.class;
            }
        };
    }

    private synchronized void destroySingletonInstance() {
        if (this.singletonComponentInstance != null) {
            this.destroyInstance((ComponentInstance)this.singletonComponentInstance);
            this.singletonComponentInstance = null;
        }
    }

    @Override
    public Object invoke(Serializable sessionId, Map<String, Object> contextData, Class<?> invokedBusinessInterface, Method beanMethod, Object[] args) throws Exception {
        if (sessionId != null) {
            throw new IllegalArgumentException("Singleton " + (Object)((Object)this) + " does not support sessions");
        }
        if (invokedBusinessInterface != null) {
            throw new UnsupportedOperationException("invokedBusinessInterface != null");
        }
        InterceptorContext context = new InterceptorContext();
        context.putPrivateData(Component.class, (Object)this);
        context.setContextData(contextData);
        context.setMethod(beanMethod);
        context.setParameters(args);
        return this.getComponentInterceptor().processInvocation(context);
    }
}

